/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.create.p2p.tunnel.input;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.TpReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.create.p2p.tunnel.input.Source;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TpId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SourceBuilder
implements Builder<Source> {
    private NodeId _node;
    private TpId _tp;
    Map<Class<? extends Augmentation<Source>>, Augmentation<Source>> augmentation = Collections.emptyMap();

    public SourceBuilder() {
    }

    public SourceBuilder(TpReference arg) {
        this._node = arg.getNode();
        this._tp = arg.getTp();
    }

    public SourceBuilder(Source base) {
        AugmentationHolder casted;
        this._node = base.getNode();
        this._tp = base.getTp();
        if (base instanceof SourceImpl) {
            SourceImpl impl = (SourceImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Source>>, Augmentation<Source>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TpReference) {
            this._node = ((TpReference)arg).getNode();
            this._tp = ((TpReference)arg).getTp();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.TpReference]");
    }

    public NodeId getNode() {
        return this._node;
    }

    public TpId getTp() {
        return this._tp;
    }

    public <E extends Augmentation<Source>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public SourceBuilder setNode(NodeId value) {
        this._node = value;
        return this;
    }

    public SourceBuilder setTp(TpId value) {
        this._tp = value;
        return this;
    }

    public SourceBuilder addAugmentation(Class<? extends Augmentation<Source>> augmentationType, Augmentation<Source> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Source>>, Augmentation<Source>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SourceBuilder removeAugmentation(Class<? extends Augmentation<Source>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Source build() {
        return new SourceImpl(this);
    }

    private static final class SourceImpl
    implements Source {
        private final NodeId _node;
        private final TpId _tp;
        private Map<Class<? extends Augmentation<Source>>, Augmentation<Source>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private SourceImpl(SourceBuilder base) {
            this._node = base.getNode();
            this._tp = base.getTp();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Source> getImplementedInterface() {
            return Source.class;
        }

        @Override
        public NodeId getNode() {
            return this._node;
        }

        @Override
        public TpId getTp() {
            return this._tp;
        }

        @Override
        public <E extends Augmentation<Source>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._tp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Source.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Source other = (Source)obj;
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._tp, other.getTp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SourceImpl otherImpl = (SourceImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Source>>, Augmentation<Source>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Source");
            CodeHelpers.appendValue(helper, "_node", this._node);
            CodeHelpers.appendValue(helper, "_tp", this._tp);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

