/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.TopologyTypes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.UnderlayTopology;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TopologyBuilder
implements Builder<Topology> {
    private List<Link> _link;
    private List<Node> _node;
    private TopologyId _topologyId;
    private TopologyTypes _topologyTypes;
    private List<UnderlayTopology> _underlayTopology;
    private Boolean _serverProvided;
    private TopologyKey key;
    Map<Class<? extends Augmentation<Topology>>, Augmentation<Topology>> augmentation = Collections.emptyMap();

    public TopologyBuilder() {
    }

    public TopologyBuilder(Topology base) {
        AugmentationHolder casted;
        if (base.key() == null) {
            this.key = new TopologyKey(base.getTopologyId());
            this._topologyId = base.getTopologyId();
        } else {
            this.key = base.key();
            this._topologyId = this.key.getTopologyId();
        }
        this._link = base.getLink();
        this._node = base.getNode();
        this._topologyTypes = base.getTopologyTypes();
        this._underlayTopology = base.getUnderlayTopology();
        this._serverProvided = base.isServerProvided();
        if (base instanceof TopologyImpl) {
            TopologyImpl impl = (TopologyImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Topology>>, Augmentation<Topology>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public TopologyKey key() {
        return this.key;
    }

    public List<Link> getLink() {
        return this._link;
    }

    public List<Node> getNode() {
        return this._node;
    }

    public TopologyId getTopologyId() {
        return this._topologyId;
    }

    public TopologyTypes getTopologyTypes() {
        return this._topologyTypes;
    }

    public List<UnderlayTopology> getUnderlayTopology() {
        return this._underlayTopology;
    }

    public Boolean isServerProvided() {
        return this._serverProvided;
    }

    public <E extends Augmentation<Topology>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public TopologyBuilder withKey(TopologyKey key) {
        this.key = key;
        return this;
    }

    public TopologyBuilder setLink(List<Link> values) {
        this._link = values;
        return this;
    }

    public TopologyBuilder setNode(List<Node> values) {
        this._node = values;
        return this;
    }

    public TopologyBuilder setTopologyId(TopologyId value) {
        this._topologyId = value;
        return this;
    }

    public TopologyBuilder setTopologyTypes(TopologyTypes value) {
        this._topologyTypes = value;
        return this;
    }

    public TopologyBuilder setUnderlayTopology(List<UnderlayTopology> values) {
        this._underlayTopology = values;
        return this;
    }

    public TopologyBuilder setServerProvided(Boolean value) {
        this._serverProvided = value;
        return this;
    }

    public TopologyBuilder addAugmentation(Class<? extends Augmentation<Topology>> augmentationType, Augmentation<Topology> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Topology>>, Augmentation<Topology>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TopologyBuilder removeAugmentation(Class<? extends Augmentation<Topology>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Topology build() {
        return new TopologyImpl(this);
    }

    private static final class TopologyImpl
    implements Topology {
        private final List<Link> _link;
        private final List<Node> _node;
        private final TopologyId _topologyId;
        private final TopologyTypes _topologyTypes;
        private final List<UnderlayTopology> _underlayTopology;
        private final Boolean _serverProvided;
        private final TopologyKey key;
        private Map<Class<? extends Augmentation<Topology>>, Augmentation<Topology>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private TopologyImpl(TopologyBuilder base) {
            if (base.key() == null) {
                this.key = new TopologyKey(base.getTopologyId());
                this._topologyId = base.getTopologyId();
            } else {
                this.key = base.key();
                this._topologyId = this.key.getTopologyId();
            }
            this._link = base.getLink();
            this._node = base.getNode();
            this._topologyTypes = base.getTopologyTypes();
            this._underlayTopology = base.getUnderlayTopology();
            this._serverProvided = base.isServerProvided();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Topology> getImplementedInterface() {
            return Topology.class;
        }

        @Override
        public TopologyKey key() {
            return this.key;
        }

        @Override
        public List<Link> getLink() {
            return this._link;
        }

        @Override
        public List<Node> getNode() {
            return this._node;
        }

        @Override
        public TopologyId getTopologyId() {
            return this._topologyId;
        }

        @Override
        public TopologyTypes getTopologyTypes() {
            return this._topologyTypes;
        }

        @Override
        public List<UnderlayTopology> getUnderlayTopology() {
            return this._underlayTopology;
        }

        @Override
        public Boolean isServerProvided() {
            return this._serverProvided;
        }

        @Override
        public <E extends Augmentation<Topology>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._link);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._topologyId);
            result = 31 * result + Objects.hashCode(this._topologyTypes);
            result = 31 * result + Objects.hashCode(this._underlayTopology);
            result = 31 * result + Objects.hashCode(this._serverProvided);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Topology.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Topology other = (Topology)obj;
            if (!Objects.equals(this._link, other.getLink())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._topologyId, other.getTopologyId())) {
                return false;
            }
            if (!Objects.equals(this._topologyTypes, other.getTopologyTypes())) {
                return false;
            }
            if (!Objects.equals(this._underlayTopology, other.getUnderlayTopology())) {
                return false;
            }
            if (!Objects.equals(this._serverProvided, other.isServerProvided())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TopologyImpl otherImpl = (TopologyImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Topology>>, Augmentation<Topology>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Topology");
            CodeHelpers.appendValue(helper, "_link", this._link);
            CodeHelpers.appendValue(helper, "_node", this._node);
            CodeHelpers.appendValue(helper, "_topologyId", this._topologyId);
            CodeHelpers.appendValue(helper, "_topologyTypes", this._topologyTypes);
            CodeHelpers.appendValue(helper, "_underlayTopology", this._underlayTopology);
            CodeHelpers.appendValue(helper, "_serverProvided", this._serverProvided);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

