/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.node;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TpAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TpId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.node.TerminationPoint;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.node.TerminationPointKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TerminationPointBuilder
implements Builder<TerminationPoint> {
    private TpId _tpId;
    private List<TpId> _tpRef;
    private TerminationPointKey key;
    Map<Class<? extends Augmentation<TerminationPoint>>, Augmentation<TerminationPoint>> augmentation = Collections.emptyMap();

    public TerminationPointBuilder() {
    }

    public TerminationPointBuilder(TpAttributes arg) {
        this._tpId = arg.getTpId();
        this._tpRef = arg.getTpRef();
    }

    public TerminationPointBuilder(TerminationPoint base) {
        AugmentationHolder casted;
        if (base.key() == null) {
            this.key = new TerminationPointKey(base.getTpId());
            this._tpId = base.getTpId();
        } else {
            this.key = base.key();
            this._tpId = this.key.getTpId();
        }
        this._tpRef = base.getTpRef();
        if (base instanceof TerminationPointImpl) {
            TerminationPointImpl impl = (TerminationPointImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TerminationPoint>>, Augmentation<TerminationPoint>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TpAttributes) {
            this._tpId = ((TpAttributes)arg).getTpId();
            this._tpRef = ((TpAttributes)arg).getTpRef();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TpAttributes]");
    }

    public TerminationPointKey key() {
        return this.key;
    }

    public TpId getTpId() {
        return this._tpId;
    }

    public List<TpId> getTpRef() {
        return this._tpRef;
    }

    public <E extends Augmentation<TerminationPoint>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public TerminationPointBuilder withKey(TerminationPointKey key) {
        this.key = key;
        return this;
    }

    public TerminationPointBuilder setTpId(TpId value) {
        this._tpId = value;
        return this;
    }

    public TerminationPointBuilder setTpRef(List<TpId> values) {
        this._tpRef = values;
        return this;
    }

    public TerminationPointBuilder addAugmentation(Class<? extends Augmentation<TerminationPoint>> augmentationType, Augmentation<TerminationPoint> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TerminationPoint>>, Augmentation<TerminationPoint>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TerminationPointBuilder removeAugmentation(Class<? extends Augmentation<TerminationPoint>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public TerminationPoint build() {
        return new TerminationPointImpl(this);
    }

    private static final class TerminationPointImpl
    implements TerminationPoint {
        private final TpId _tpId;
        private final List<TpId> _tpRef;
        private final TerminationPointKey key;
        private Map<Class<? extends Augmentation<TerminationPoint>>, Augmentation<TerminationPoint>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private TerminationPointImpl(TerminationPointBuilder base) {
            if (base.key() == null) {
                this.key = new TerminationPointKey(base.getTpId());
                this._tpId = base.getTpId();
            } else {
                this.key = base.key();
                this._tpId = this.key.getTpId();
            }
            this._tpRef = base.getTpRef();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<TerminationPoint> getImplementedInterface() {
            return TerminationPoint.class;
        }

        @Override
        public TerminationPointKey key() {
            return this.key;
        }

        @Override
        public TpId getTpId() {
            return this._tpId;
        }

        @Override
        public List<TpId> getTpRef() {
            return this._tpRef;
        }

        @Override
        public <E extends Augmentation<TerminationPoint>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._tpId);
            result = 31 * result + Objects.hashCode(this._tpRef);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TerminationPoint.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TerminationPoint other = (TerminationPoint)obj;
            if (!Objects.equals(this._tpId, other.getTpId())) {
                return false;
            }
            if (!Objects.equals(this._tpRef, other.getTpRef())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TerminationPointImpl otherImpl = (TerminationPointImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TerminationPoint>>, Augmentation<TerminationPoint>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("TerminationPoint");
            CodeHelpers.appendValue(helper, "_tpId", this._tpId);
            CodeHelpers.appendValue(helper, "_tpRef", this._tpRef);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

