/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.node.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.node.attributes.SupportingNode;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.node.attributes.SupportingNodeKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SupportingNodeBuilder
implements Builder<SupportingNode> {
    private NodeId _nodeRef;
    private TopologyId _topologyRef;
    private SupportingNodeKey key;
    Map<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>> augmentation = Collections.emptyMap();

    public SupportingNodeBuilder() {
    }

    public SupportingNodeBuilder(SupportingNode base) {
        AugmentationHolder casted;
        if (base.key() == null) {
            this.key = new SupportingNodeKey(base.getNodeRef(), base.getTopologyRef());
            this._nodeRef = base.getNodeRef();
            this._topologyRef = base.getTopologyRef();
        } else {
            this.key = base.key();
            this._nodeRef = this.key.getNodeRef();
            this._topologyRef = this.key.getTopologyRef();
        }
        if (base instanceof SupportingNodeImpl) {
            SupportingNodeImpl impl = (SupportingNodeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public SupportingNodeKey key() {
        return this.key;
    }

    public NodeId getNodeRef() {
        return this._nodeRef;
    }

    public TopologyId getTopologyRef() {
        return this._topologyRef;
    }

    public <E extends Augmentation<SupportingNode>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public SupportingNodeBuilder withKey(SupportingNodeKey key) {
        this.key = key;
        return this;
    }

    public SupportingNodeBuilder setNodeRef(NodeId value) {
        this._nodeRef = value;
        return this;
    }

    public SupportingNodeBuilder setTopologyRef(TopologyId value) {
        this._topologyRef = value;
        return this;
    }

    public SupportingNodeBuilder addAugmentation(Class<? extends Augmentation<SupportingNode>> augmentationType, Augmentation<SupportingNode> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SupportingNodeBuilder removeAugmentation(Class<? extends Augmentation<SupportingNode>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SupportingNode build() {
        return new SupportingNodeImpl(this);
    }

    private static final class SupportingNodeImpl
    implements SupportingNode {
        private final NodeId _nodeRef;
        private final TopologyId _topologyRef;
        private final SupportingNodeKey key;
        private Map<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private SupportingNodeImpl(SupportingNodeBuilder base) {
            if (base.key() == null) {
                this.key = new SupportingNodeKey(base.getNodeRef(), base.getTopologyRef());
                this._nodeRef = base.getNodeRef();
                this._topologyRef = base.getTopologyRef();
            } else {
                this.key = base.key();
                this._nodeRef = this.key.getNodeRef();
                this._topologyRef = this.key.getTopologyRef();
            }
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<SupportingNode> getImplementedInterface() {
            return SupportingNode.class;
        }

        @Override
        public SupportingNodeKey key() {
            return this.key;
        }

        @Override
        public NodeId getNodeRef() {
            return this._nodeRef;
        }

        @Override
        public TopologyId getTopologyRef() {
            return this._topologyRef;
        }

        @Override
        public <E extends Augmentation<SupportingNode>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._nodeRef);
            result = 31 * result + Objects.hashCode(this._topologyRef);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SupportingNode.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SupportingNode other = (SupportingNode)obj;
            if (!Objects.equals(this._nodeRef, other.getNodeRef())) {
                return false;
            }
            if (!Objects.equals(this._topologyRef, other.getTopologyRef())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SupportingNodeImpl otherImpl = (SupportingNodeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SupportingNode");
            CodeHelpers.appendValue(helper, "_nodeRef", this._nodeRef);
            CodeHelpers.appendValue(helper, "_topologyRef", this._topologyRef);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

