/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Variant;

@Beta
@NonNullByDefault
@ThreadSafe
public class CheckedValue<T, E extends Exception>
extends Variant<T, E> {
    protected CheckedValue(T value) {
        super(value);
    }

    protected CheckedValue(E violation, @Nullable Void dummy) {
        super(violation, dummy);
    }

    public static <T, E extends Exception> CheckedValue<T, E> ofException(E cause) {
        return new CheckedValue<T, E>(cause, null);
    }

    public static <T, E extends Exception> CheckedValue<T, E> ofValue(T value) {
        return new CheckedValue<T, E>(value);
    }

    public static <T, U, E extends Exception> CheckedValue<T, E> ofVariant(Variant<T, U> variant, Function<U, E> mapper) {
        Objects.requireNonNull(mapper);
        return variant.isFirst() ? new CheckedValue<T, E>(variant.first()) : new CheckedValue<T, Exception>((Exception)mapper.apply(variant.second()), null);
    }

    public final T get() {
        if (this.isFirst()) {
            return this.first();
        }
        throw new IllegalStateException("Value is not present", (Throwable)this.second());
    }

    public final E getException() {
        if (this.isSecond()) {
            return (E)((Exception)this.second());
        }
        throw new IllegalStateException("Value " + this.first() + " is present");
    }

    public final boolean isPresent() {
        return this.isFirst();
    }

    public final void ifPresent(Consumer<? super T> consumer) {
        if (this.isFirst()) {
            consumer.accept(this.first());
        }
    }

    public <U> CheckedValue<U, E> map(Function<? super T, U> mapper) {
        Objects.requireNonNull(mapper);
        return this.isFirst() ? new CheckedValue<U, E>(mapper.apply(this.first())) : this;
    }

    public <X extends Exception> CheckedValue<T, X> mapException(Function<? super E, X> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isFirst()) {
            return this;
        }
        return new CheckedValue<T, Exception>((Exception)mapper.apply(this.second()), null);
    }

    public <U> CheckedValue<U, E> flatMap(Function<? super T, CheckedValue<U, E>> mapper) {
        Objects.requireNonNull(mapper);
        return this.isFirst() ? Objects.requireNonNull(mapper.apply(this.first())) : this;
    }

    public final T orElse(T other) {
        return this.isFirst() ? this.first() : other;
    }

    public final T orElseGet(Supplier<T> supplier) {
        Objects.requireNonNull(supplier);
        return this.isFirst() ? this.first() : supplier.get();
    }

    public final <X extends Throwable> T orElseThrow() throws E {
        if (this.isFirst()) {
            return this.first();
        }
        throw (Exception)this.second();
    }

    public final <X extends Throwable> T orElseThrow(Function<E, X> exceptionMapper) throws X {
        Objects.requireNonNull(exceptionMapper);
        if (this.isFirst()) {
            return this.first();
        }
        throw (Throwable)exceptionMapper.apply(this.second());
    }

    public final <X extends Throwable> T orElseThrow(Supplier<X> supplier) throws X {
        Objects.requireNonNull(supplier);
        if (this.isFirst()) {
            return this.first();
        }
        throw (Throwable)supplier.get();
    }

    public final boolean completeFuture(CompletableFuture<T> future) {
        return this.isFirst() ? future.complete(this.first()) : future.completeExceptionally((Throwable)this.second());
    }

    public final boolean completeFuture(SettableFuture<T> future) {
        return this.isFirst() ? future.set(this.first()) : future.setException((Throwable)this.second());
    }

    public final CompletableFuture<T> toCompletableFuture() {
        if (this.isFirst()) {
            return CompletableFuture.completedFuture(this.first());
        }
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally((Throwable)this.second());
        return future;
    }

    public final FluentFuture<T> toFluentFuture() {
        ListenableFuture<Object> future = this.isFirst() ? Futures.immediateFuture(this.first()) : Futures.immediateFailedFuture((Throwable)this.second());
        return FluentFuture.from(future);
    }
}

