/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.triemap;

import java.util.AbstractSet;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import org.opendaylight.yangtools.triemap.TrieMap;

abstract class AbstractEntrySet<K, V>
extends AbstractSet<Map.Entry<K, V>> {
    private final TrieMap<K, V> map;

    AbstractEntrySet(TrieMap<K, V> map) {
        this.map = Objects.requireNonNull(map);
    }

    final TrieMap<K, V> map() {
        return this.map;
    }

    @Override
    public final boolean contains(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry e = (Map.Entry)o;
        Object key = e.getKey();
        if (key == null) {
            return false;
        }
        V v = this.map.get(key);
        return v != null && v.equals(e.getValue());
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final Spliterator<Map.Entry<K, V>> spliterator() {
        return Spliterators.spliterator(this.map.immutableIterator(), Long.MAX_VALUE, this.characteristics());
    }

    abstract int characteristics();
}

