/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.triemap;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.opendaylight.yangtools.triemap.BasicNode;
import org.opendaylight.yangtools.triemap.CNode;
import org.opendaylight.yangtools.triemap.EntryNode;
import org.opendaylight.yangtools.triemap.INode;
import org.opendaylight.yangtools.triemap.ImmutableTrieMap;
import org.opendaylight.yangtools.triemap.LNode;
import org.opendaylight.yangtools.triemap.LNodeEntries;
import org.opendaylight.yangtools.triemap.MainNode;
import org.opendaylight.yangtools.triemap.SNode;
import org.opendaylight.yangtools.triemap.TNode;
import org.opendaylight.yangtools.triemap.TrieMap;

abstract class AbstractIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private final BasicNode[][] nodeStack = new BasicNode[7][];
    private final int[] positionStack = new int[7];
    private final TrieMap<K, V> map;
    private LNodeEntries<K, V> lnode;
    private EntryNode<K, V> current;
    private int depth = -1;

    AbstractIterator(ImmutableTrieMap<K, V> map) {
        this.map = map;
        this.readin(map.RDCSS_READ_ROOT());
    }

    @Override
    public final boolean hasNext() {
        return this.current != null || this.lnode != null;
    }

    @Override
    public final Map.Entry<K, V> next() {
        Map.Entry<K, V> entry;
        if (this.lnode != null) {
            entry = this.lnode;
            this.lnode = this.lnode.next();
            if (this.lnode == null) {
                this.advance();
            }
        } else {
            entry = this.current;
            this.advance();
        }
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return this.wrapEntry(entry);
    }

    abstract Map.Entry<K, V> wrapEntry(Map.Entry<K, V> var1);

    private void readin(INode<K, V> in) {
        MainNode<K, V> m = in.gcasRead(this.map);
        if (m instanceof CNode) {
            CNode cn = (CNode)m;
            ++this.depth;
            this.nodeStack[this.depth] = cn.array;
            this.positionStack[this.depth] = -1;
            this.advance();
        } else if (m instanceof TNode) {
            this.current = (TNode)m;
        } else if (m instanceof LNode) {
            this.lnode = ((LNode)m).entries();
        } else if (m == null) {
            this.current = null;
        }
    }

    private void advance() {
        if (this.depth >= 0) {
            int npos = this.positionStack[this.depth] + 1;
            if (npos < this.nodeStack[this.depth].length) {
                this.positionStack[this.depth] = npos;
                BasicNode elem = this.nodeStack[this.depth][npos];
                if (elem instanceof SNode) {
                    this.current = (SNode)elem;
                } else if (elem instanceof INode) {
                    this.readin((INode)elem);
                }
            } else {
                --this.depth;
                this.advance();
            }
        } else {
            this.current = null;
        }
    }
}

