/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.triemap;

import java.io.Serializable;
import javax.annotation.Nonnull;

abstract class Equivalence<T>
implements Serializable {
    private static final long serialVersionUID = 1L;

    Equivalence() {
    }

    static Equivalence<Object> equals() {
        return Equals.INSTANCE;
    }

    static Equivalence<Object> identity() {
        return Identity.INSTANCE;
    }

    final int hash(@Nonnull T t) {
        int h = t.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h;
    }

    abstract boolean equivalent(@Nonnull T var1, @Nonnull T var2);

    abstract Object readResolve();

    private static final class Identity
    extends Equivalence<Object> {
        private static final long serialVersionUID = 1L;
        static final Identity INSTANCE = new Identity();

        private Identity() {
        }

        @Override
        boolean equivalent(Object a, Object b) {
            return a == b;
        }

        @Override
        Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class Equals
    extends Equivalence<Object> {
        private static final long serialVersionUID = 1L;
        static final Equals INSTANCE = new Equals();

        private Equals() {
        }

        @Override
        boolean equivalent(Object a, Object b) {
            return a.equals(b);
        }

        @Override
        Object readResolve() {
            return INSTANCE;
        }
    }
}

