/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.triemap;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.opendaylight.yangtools.triemap.Equivalence;
import org.opendaylight.yangtools.triemap.Gen;
import org.opendaylight.yangtools.triemap.INode;
import org.opendaylight.yangtools.triemap.ImmutableEntrySet;
import org.opendaylight.yangtools.triemap.ImmutableIterator;
import org.opendaylight.yangtools.triemap.ImmutableKeySet;
import org.opendaylight.yangtools.triemap.MutableTrieMap;
import org.opendaylight.yangtools.triemap.TrieMap;

@Beta
public final class ImmutableTrieMap<K, V>
extends TrieMap<K, V> {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Handled by SerializationProxy")
    private final INode<K, V> root;

    ImmutableTrieMap(INode<K, V> root, Equivalence<? super K> equiv) {
        super(equiv);
        this.root = Objects.requireNonNull(root);
    }

    @Override
    public void clear() {
        throw ImmutableTrieMap.unsupported();
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw ImmutableTrieMap.unsupported();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw ImmutableTrieMap.unsupported();
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw ImmutableTrieMap.unsupported();
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw ImmutableTrieMap.unsupported();
    }

    @Override
    public V put(K key, V value) {
        throw ImmutableTrieMap.unsupported();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw ImmutableTrieMap.unsupported();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        throw ImmutableTrieMap.unsupported();
    }

    @Override
    public V remove(Object key) {
        throw ImmutableTrieMap.unsupported();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw ImmutableTrieMap.unsupported();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw ImmutableTrieMap.unsupported();
    }

    @Override
    public V replace(K key, V value) {
        throw ImmutableTrieMap.unsupported();
    }

    @Override
    public int size() {
        return this.root.size(this);
    }

    @Override
    public TrieMap<K, V> mutableSnapshot() {
        return new MutableTrieMap(this.equiv(), new INode<K, V>(new Gen(), this.root.gcasRead(this)));
    }

    @Override
    public ImmutableTrieMap<K, V> immutableSnapshot() {
        return this;
    }

    @Override
    ImmutableEntrySet<K, V> createEntrySet() {
        return new ImmutableEntrySet(this);
    }

    @Override
    ImmutableKeySet<K> createKeySet() {
        return new ImmutableKeySet(this);
    }

    @Override
    boolean isReadOnly() {
        return true;
    }

    @Override
    ImmutableIterator<K, V> iterator() {
        return this.immutableIterator();
    }

    @Override
    INode<K, V> RDCSS_READ_ROOT(boolean abort) {
        return this.root;
    }

    static UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("Attempted to modify a read-only view");
    }
}

