/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.triemap;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.triemap.Equivalence;
import org.opendaylight.yangtools.triemap.ImmutableTrieMap;
import org.opendaylight.yangtools.triemap.MutableTrieMap;
import org.opendaylight.yangtools.triemap.TrieMap;

final class SerializationProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private TrieMap<Object, Object> map;
    private boolean readOnly;

    public SerializationProxy() {
    }

    SerializationProxy(ImmutableTrieMap<?, ?> map, boolean readOnly) {
        this.map = Objects.requireNonNull(map);
        this.readOnly = readOnly;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.map.equiv());
        out.writeInt(this.map.size());
        for (Map.Entry<Object, Object> e : this.map.entrySet()) {
            out.writeObject(e.getKey());
            out.writeObject(e.getValue());
        }
        out.writeBoolean(this.readOnly);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Equivalence equiv = (Equivalence)in.readObject();
        Preconditions.checkArgument(equiv != null);
        MutableTrieMap<Object, Object> tmp = new MutableTrieMap<Object, Object>(equiv);
        int size = in.readInt();
        Preconditions.checkArgument(size >= 0);
        for (int i = 0; i < size; ++i) {
            tmp.add(in.readObject(), in.readObject());
        }
        this.map = in.readBoolean() ? tmp.immutableSnapshot() : tmp;
    }

    private Object readResolve() throws ObjectStreamException {
        return Verify.verifyNotNull(this.map);
    }
}

