/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.triemap;

import com.google.common.annotations.Beta;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.yangtools.triemap.AbstractEntrySet;
import org.opendaylight.yangtools.triemap.AbstractIterator;
import org.opendaylight.yangtools.triemap.AbstractKeySet;
import org.opendaylight.yangtools.triemap.Equivalence;
import org.opendaylight.yangtools.triemap.INode;
import org.opendaylight.yangtools.triemap.ImmutableIterator;
import org.opendaylight.yangtools.triemap.ImmutableTrieMap;
import org.opendaylight.yangtools.triemap.LookupResult;
import org.opendaylight.yangtools.triemap.MutableTrieMap;
import org.opendaylight.yangtools.triemap.SerializationProxy;

@Beta
public abstract class TrieMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Equivalence<? super K> equiv;
    private AbstractEntrySet<K, V> entrySet;
    private AbstractKeySet<K> keySet;

    TrieMap(Equivalence<? super K> equiv) {
        this.equiv = equiv;
    }

    public static <K, V> MutableTrieMap<K, V> create() {
        return new MutableTrieMap(Equivalence.equals());
    }

    public abstract TrieMap<K, V> mutableSnapshot();

    public abstract ImmutableTrieMap<K, V> immutableSnapshot();

    @Override
    public final boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public final boolean containsValue(Object value) {
        return super.containsValue(Objects.requireNonNull(value));
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        AbstractEntrySet<K, V> ret = this.entrySet;
        return ret != null ? ret : (this.entrySet = this.createEntrySet());
    }

    @Override
    public final Set<K> keySet() {
        AbstractKeySet<K> ret = this.keySet;
        return ret != null ? ret : (this.keySet = this.createKeySet());
    }

    @Override
    public final V get(Object key) {
        Object k = Objects.requireNonNull(key);
        return this.lookuphc(k, this.computeHash(k));
    }

    @Override
    public abstract void clear();

    @Override
    public abstract V put(K var1, V var2);

    @Override
    public abstract V putIfAbsent(K var1, V var2);

    @Override
    public abstract V remove(Object var1);

    @Override
    public abstract boolean remove(Object var1, Object var2);

    @Override
    public abstract boolean replace(K var1, V var2, V var3);

    @Override
    public abstract V replace(K var1, V var2);

    @Override
    public abstract int size();

    abstract AbstractEntrySet<K, V> createEntrySet();

    abstract AbstractKeySet<K> createKeySet();

    abstract boolean isReadOnly();

    abstract INode<K, V> RDCSS_READ_ROOT(boolean var1);

    abstract AbstractIterator<K, V> iterator();

    final ImmutableIterator<K, V> immutableIterator() {
        return new ImmutableIterator<K, V>(this.immutableSnapshot());
    }

    static <V> V toNullable(Optional<V> opt) {
        return opt.orElse(null);
    }

    final int computeHash(K key) {
        return this.equiv.hash(key);
    }

    final Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this.immutableSnapshot(), this.isReadOnly());
    }

    final Equivalence<? super K> equiv() {
        return this.equiv;
    }

    final INode<K, V> readRoot() {
        return this.RDCSS_READ_ROOT(false);
    }

    final INode<K, V> readRoot(boolean abort) {
        return this.RDCSS_READ_ROOT(abort);
    }

    final INode<K, V> RDCSS_READ_ROOT() {
        return this.RDCSS_READ_ROOT(false);
    }

    final boolean equal(K k1, K k2) {
        return this.equiv.equivalent(k1, k2);
    }

    private V lookuphc(K key, int hc) {
        Object res;
        while ((res = this.RDCSS_READ_ROOT().recLookup(key, hc, 0, null, this)) == LookupResult.RESTART) {
        }
        return (V)res;
    }
}

