/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.util.SingletonSet;

@Beta
@NonNullByDefault
public final class CollectionWrappers {
    private CollectionWrappers() {
    }

    public static <E> List<E> wrapAsList(Collection<E> collection) {
        if (collection.isEmpty()) {
            return ImmutableList.of();
        }
        if (collection instanceof List) {
            List cast = (List)collection;
            return cast instanceof ListWrapper || cast instanceof Immutable || cast instanceof ImmutableList ? cast : Collections.unmodifiableList(cast);
        }
        return new ListWrapper(collection);
    }

    public static <E> Set<E> wrapAsSet(Collection<E> collection) {
        if (collection.isEmpty()) {
            return ImmutableSet.of();
        }
        if (collection instanceof Set) {
            Set cast = (Set)collection;
            return cast instanceof SetWrapper || cast instanceof Immutable || cast instanceof SingletonSet || cast instanceof ImmutableSet ? cast : Collections.unmodifiableSet(cast);
        }
        ImmutableSet<E> check = ImmutableSet.copyOf(collection);
        Preconditions.checkArgument(collection.size() == check.size(), "Supplied collection %s has duplicate elements", collection);
        return new SetWrapper(collection);
    }

    private static final class SetWrapper<E>
    extends AbstractSet<E> {
        private final Collection<E> delegate;

        private SetWrapper(Collection<E> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.unmodifiableIterator(this.delegate.iterator());
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.delegate.spliterator();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.delegate.parallelStream();
        }

        @Override
        public Stream<E> stream() {
            return this.delegate.stream();
        }
    }

    private static final class ListWrapper<E>
    extends AbstractList<E> {
        private final Collection<E> delegate;

        private ListWrapper(Collection<E> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.unmodifiableIterator(this.delegate.iterator());
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.delegate.spliterator();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.delegate.parallelStream();
        }

        @Override
        public Stream<E> stream() {
            return this.delegate.stream();
        }

        @Override
        public E get(int index) {
            return Iterables.get(this.delegate, index);
        }
    }
}

