/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.util.concurrent.ForwardingBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorServiceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorServiceUtil.class);
    private static final RejectedExecutionHandler WAIT_IN_QUEUE_HANDLER = new WaitInQueueExecutionHandler();

    private ExecutorServiceUtil() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static <E> BlockingQueue<E> offerFailingBlockingQueue(final BlockingQueue<E> delegate) {
        return new ForwardingBlockingQueue<E>(){

            @Override
            public boolean offer(@Nonnull E o) {
                return false;
            }

            @Override
            protected BlockingQueue<E> delegate() {
                return delegate;
            }
        };
    }

    public static RejectedExecutionHandler waitInQueueExecutionHandler() {
        return WAIT_IN_QUEUE_HANDLER;
    }

    public static void tryGracefulShutdown(ExecutorService executor, long timeout, TimeUnit unit) {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(timeout, unit)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
        }
    }

    private static final class WaitInQueueExecutionHandler
    implements RejectedExecutionHandler {
        private WaitInQueueExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("Executor has been shutdown.");
            }
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                LOG.debug("Interrupted while attempting to put to the queue", e);
                throw new RejectedExecutionException("Interrupted while attempting to put to the queue", e);
            }
        }
    }
}

