/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class UnmodifiableCollection<E>
implements Collection<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Class<?> UNMODIFIABLE_COLLECTION_CLASS = Collections.unmodifiableCollection(new ArrayList()).getClass();
    private static final Collection<Class<?>> SINGLETON_CLASSES;
    private final Collection<E> delegate;

    private UnmodifiableCollection(Collection<E> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public static <T> Collection<T> create(@Nonnull Collection<T> collection) {
        if (collection instanceof UnmodifiableCollection || collection instanceof ImmutableCollection || Collections.EMPTY_LIST == collection || Collections.EMPTY_SET == collection || UNMODIFIABLE_COLLECTION_CLASS.isInstance(collection) || SINGLETON_CLASSES.contains(collection.getClass())) {
            return collection;
        }
        return new UnmodifiableCollection<T>(collection);
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return Iterators.unmodifiableIterator(this.delegate.iterator());
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(@Nonnull T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "UnmodifiableCollection{" + this.delegate + "}";
    }

    static {
        ImmutableSet.Builder b = ImmutableSet.builder();
        b.add(Collections.singleton(null).getClass());
        b.add(Collections.singletonList(null).getClass());
        SINGLETON_CLASSES = b.build();
    }
}

