/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.util.concurrent.AsyncNotifyingListeningExecutorService;
import org.opendaylight.yangtools.util.concurrent.SettableBoolean;
import org.opendaylight.yangtools.util.concurrent.SettableBooleanThreadLocal;

public class DeadlockDetectingListeningExecutorService
extends AsyncNotifyingListeningExecutorService {
    private final SettableBooleanThreadLocal deadlockDetector = new SettableBooleanThreadLocal();
    private final Supplier<Exception> deadlockExceptionFunction;

    public DeadlockDetectingListeningExecutorService(ExecutorService delegate, @Nonnull Supplier<Exception> deadlockExceptionSupplier) {
        this(delegate, deadlockExceptionSupplier, null);
    }

    public DeadlockDetectingListeningExecutorService(ExecutorService delegate, @Nonnull Supplier<Exception> deadlockExceptionSupplier, @Nullable Executor listenableFutureExecutor) {
        super(delegate, listenableFutureExecutor);
        this.deadlockExceptionFunction = Objects.requireNonNull(deadlockExceptionSupplier);
    }

    @Override
    public void execute(@Nonnull Runnable command) {
        this.getDelegate().execute(this.wrapRunnable(command));
    }

    @Override
    @Nonnull
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return this.wrapListenableFuture((ListenableFuture<T>)super.submit((Callable)this.wrapCallable(task)));
    }

    @Override
    @Nonnull
    public ListenableFuture<?> submit(Runnable task) {
        return this.wrapListenableFuture((ListenableFuture)super.submit(this.wrapRunnable(task)));
    }

    @Override
    @Nonnull
    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        return this.wrapListenableFuture((ListenableFuture<T>)super.submit(this.wrapRunnable(task), (Object)result));
    }

    public void cleanStateForCurrentThread() {
        this.deadlockDetector.remove();
    }

    private SettableBoolean primeDetector() {
        SettableBoolean b = (SettableBoolean)this.deadlockDetector.get();
        Preconditions.checkState(!b.isSet(), "Detector for {} has already been primed", (Object)this);
        b.set();
        return b;
    }

    private Runnable wrapRunnable(Runnable task) {
        return () -> {
            SettableBoolean b = this.primeDetector();
            try {
                task.run();
            }
            finally {
                b.reset();
            }
        };
    }

    private <T> Callable<T> wrapCallable(Callable<T> delagate) {
        return () -> {
            SettableBoolean b = this.primeDetector();
            try {
                Object v = delagate.call();
                return v;
            }
            finally {
                b.reset();
            }
        };
    }

    private <T> ListenableFuture<T> wrapListenableFuture(ListenableFuture<T> delegate) {
        return new ForwardingListenableFuture.SimpleForwardingListenableFuture<T>(delegate){

            @Override
            public T get() throws InterruptedException, ExecutionException {
                this.checkDeadLockDetectorTL();
                return super.get();
            }

            @Override
            public T get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                this.checkDeadLockDetectorTL();
                return super.get(timeout, unit);
            }

            void checkDeadLockDetectorTL() throws ExecutionException {
                if (((SettableBoolean)DeadlockDetectingListeningExecutorService.this.deadlockDetector.get()).isSet()) {
                    throw new ExecutionException("A potential deadlock was detected.", (Throwable)DeadlockDetectingListeningExecutorService.this.deadlockExceptionFunction.get());
                }
            }
        };
    }
}

