/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.opendaylight.yangtools.util.concurrent.CachedThreadPoolExecutor;
import org.opendaylight.yangtools.util.concurrent.CountingRejectedExecutionHandler;
import org.opendaylight.yangtools.util.concurrent.FastThreadPoolExecutor;

public final class SpecialExecutors {
    private SpecialExecutors() {
    }

    public static ExecutorService newBoundedFastThreadPool(int maximumPoolSize, int maximumQueueSize, String threadPrefix, Class<?> loggerIdentity) {
        return new FastThreadPoolExecutor(maximumPoolSize, maximumQueueSize, threadPrefix, loggerIdentity);
    }

    public static ExecutorService newBlockingBoundedFastThreadPool(int maximumPoolSize, int maximumQueueSize, String threadPrefix, Class<?> loggerIdentity) {
        FastThreadPoolExecutor executor = new FastThreadPoolExecutor(maximumPoolSize, maximumQueueSize, threadPrefix, loggerIdentity);
        executor.setRejectedExecutionHandler(CountingRejectedExecutionHandler.newCallerRunsPolicy());
        return executor;
    }

    public static ExecutorService newBoundedCachedThreadPool(int maximumPoolSize, int maximumQueueSize, String threadPrefix, Class<?> loggerIdentity) {
        return new CachedThreadPoolExecutor(maximumPoolSize, maximumQueueSize, threadPrefix, loggerIdentity);
    }

    public static ExecutorService newBlockingBoundedCachedThreadPool(int maximumPoolSize, int maximumQueueSize, String threadPrefix, Class<?> loggerIdentity) {
        CachedThreadPoolExecutor executor = new CachedThreadPoolExecutor(maximumPoolSize, maximumQueueSize, threadPrefix, loggerIdentity);
        executor.setRejectedExecutionHandler(CountingRejectedExecutionHandler.newCallerRunsPolicy());
        return executor;
    }

    public static ExecutorService newBoundedSingleThreadExecutor(int maximumQueueSize, String threadPrefix, Class<?> loggerIdentity) {
        return new FastThreadPoolExecutor(1, maximumQueueSize, Long.MAX_VALUE, TimeUnit.SECONDS, threadPrefix, loggerIdentity);
    }
}

