/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import org.immutables.value.Value;
import org.opendaylight.yangtools.util.concurrent.ImmutableThreadFactoryProvider;
import org.opendaylight.yangtools.util.concurrent.LoggingThreadUncaughtExceptionHandler;
import org.slf4j.Logger;

@Value.Immutable
@Value.Style(stagedBuilder=true)
public abstract class ThreadFactoryProvider {
    public static ImmutableThreadFactoryProvider.NamePrefixBuildStage builder() {
        return ImmutableThreadFactoryProvider.builder();
    }

    @Value.Parameter
    public abstract String namePrefix();

    @Value.Parameter
    public abstract Logger logger();

    @Value.Parameter
    public abstract Optional<Integer> priority();

    @Value.Default
    public boolean daemon() {
        return true;
    }

    public ThreadFactory get() {
        ThreadFactoryBuilder guavaBuilder = new ThreadFactoryBuilder();
        guavaBuilder.setNameFormat(this.namePrefix() + "-%d");
        guavaBuilder.setUncaughtExceptionHandler(LoggingThreadUncaughtExceptionHandler.toLogger(this.logger()));
        guavaBuilder.setDaemon(this.daemon());
        this.priority().ifPresent(guavaBuilder::setPriority);
        this.logger().info("ThreadFactory created: {}", (Object)this.namePrefix());
        return guavaBuilder.build();
    }
}

