/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifierBuilderImpl;

public class KeyedInstanceIdentifier<T extends Identifiable<K> & DataObject, K extends Identifier<T>>
extends InstanceIdentifier<T> {
    private static final long serialVersionUID = 1L;
    private final K key;

    KeyedInstanceIdentifier(Class<T> type, Iterable<InstanceIdentifier.PathArgument> pathArguments, boolean wildcarded, int hash, K key) {
        super(type, pathArguments, wildcarded, hash);
        this.key = key;
    }

    public final K getKey() {
        return this.key;
    }

    @Override
    public final InstanceIdentifier.InstanceIdentifierBuilder<T> builder() {
        return new InstanceIdentifierBuilderImpl(InstanceIdentifier.IdentifiableItem.of(this.getTargetType(), this.key), this.pathArguments, this.hashCode(), this.isWildcarded());
    }

    @Override
    protected boolean fastNonEqual(InstanceIdentifier<?> other) {
        KeyedInstanceIdentifier kii = (KeyedInstanceIdentifier)other;
        return this.key == null != (kii.key == null);
    }
}

