/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.yang.common.Revision;

public final class QNameModule
implements Comparable<QNameModule>,
Immutable,
Serializable,
Identifier,
WritableObject {
    private static final Interner<QNameModule> INTERNER = Interners.newWeakInterner();
    private static final long serialVersionUID = 3L;
    private final @NonNull URI namespace;
    private final Revision revision;
    private transient int hash;

    private QNameModule(@NonNull URI namespace, Revision revision) {
        this.namespace = Objects.requireNonNull(namespace);
        this.revision = revision;
    }

    public QNameModule intern() {
        return INTERNER.intern(this);
    }

    public static QNameModule create(URI namespace, Optional<Revision> revision) {
        return new QNameModule(namespace, revision.orElse(null));
    }

    public static QNameModule create(URI namespace) {
        return new QNameModule(namespace, null);
    }

    public static QNameModule create(URI namespace, @Nullable Revision revision) {
        return new QNameModule(namespace, revision);
    }

    public static QNameModule readFrom(DataInput in) throws IOException {
        String namespace = in.readUTF();
        String revision = in.readUTF();
        return new QNameModule(URI.create(namespace), revision.isEmpty() ? null : Revision.of(revision));
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public Optional<Revision> getRevision() {
        return Optional.ofNullable(this.revision);
    }

    @Override
    public int compareTo(QNameModule o) {
        int cmp = this.namespace.compareTo(o.namespace);
        if (cmp != 0) {
            return cmp;
        }
        return Revision.compare(this.revision, o.revision);
    }

    public QNameModule withoutRevision() {
        return this.revision == null ? this : new QNameModule(this.namespace, null);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeUTF(this.namespace.toString());
        out.writeUTF(this.revision == null ? "" : this.revision.toString());
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.namespace, this.revision);
        }
        return this.hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QNameModule)) {
            return false;
        }
        QNameModule other = (QNameModule)obj;
        return Objects.equals(this.revision, other.revision) && this.namespace.equals(other.namespace);
    }

    URI getRevisionNamespace() throws URISyntaxException {
        String query = this.revision == null ? "" : "revision=" + this.revision.toString();
        return new URI(this.namespace.getScheme(), this.namespace.getUserInfo(), this.namespace.getHost(), this.namespace.getPort(), this.namespace.getPath(), query, this.namespace.getFragment());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(QNameModule.class).omitNullValues().add("ns", this.namespace).add("rev", this.revision).toString();
    }
}

