/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Variant;
import org.opendaylight.yangtools.yang.common.AbstractCanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValue;
import org.opendaylight.yangtools.yang.common.CanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValueViolation;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;

@Beta
@NonNullByDefault
public class Uint8
extends Number
implements CanonicalValue<Uint8> {
    private static final CanonicalValueSupport<Uint8> SUPPORT = new Support();
    static final short MIN_VALUE = 0;
    static final short MAX_VALUE = 255;
    private static final long serialVersionUID = 1L;
    private static final Uint8[] CACHE = new Uint8[256];
    private final byte value;

    private Uint8(byte value) {
        this.value = value;
    }

    protected Uint8(Uint8 other) {
        this.value = other.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Uint8 instanceFor(byte value) {
        int slot = Byte.toUnsignedInt(value);
        Uint8 ret = CACHE[slot];
        if (ret != null) return ret;
        Uint8[] uint8Array = CACHE;
        synchronized (CACHE) {
            ret = CACHE[slot];
            if (ret != null) return ret;
            Uint8.CACHE[slot] = ret = new Uint8(value);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ret;
        }
    }

    public static Uint8 fromByteBits(byte bits) {
        return Uint8.instanceFor(bits);
    }

    public static Uint8 valueOf(byte byteVal) {
        Preconditions.checkArgument(byteVal >= 0, "Negative values are not allowed");
        return Uint8.instanceFor(byteVal);
    }

    public static Uint8 valueOf(short shortVal) {
        Preconditions.checkArgument(shortVal >= 0 && shortVal <= 255, "Value %s is outside of allowed range", shortVal);
        return Uint8.instanceFor((byte)(shortVal & 0xFF));
    }

    public static Uint8 valueOf(int intVal) {
        Preconditions.checkArgument(intVal >= 0 && intVal <= 255, "Value %s is outside of allowed range", intVal);
        return Uint8.instanceFor((byte)(intVal & 0xFF));
    }

    public static Uint8 valueOf(long longVal) {
        Preconditions.checkArgument(longVal >= 0L && longVal <= 255L, "Value %s is outside of allowed range", longVal);
        return Uint8.instanceFor((byte)(longVal & 0xFFL));
    }

    public static Uint8 valueOf(Uint16 uint) {
        return Uint8.valueOf(uint.intValue());
    }

    public static Uint8 valueOf(Uint32 uint) {
        return Uint8.valueOf(uint.longValue());
    }

    public static Uint8 valueOf(Uint64 uint) {
        return Uint8.valueOf(uint.longValue());
    }

    public static Uint8 valueOf(String string) {
        return Uint8.valueOf(string, 10);
    }

    public static Uint8 valueOf(String string, int radix) {
        return Uint8.valueOf(Short.parseShort(string, radix));
    }

    @Override
    public final byte byteValue() {
        return this.value;
    }

    @Override
    public final int intValue() {
        return Byte.toUnsignedInt(this.value);
    }

    @Override
    public final long longValue() {
        return Byte.toUnsignedLong(this.value);
    }

    @Override
    public final float floatValue() {
        return this.intValue();
    }

    @Override
    public final double doubleValue() {
        return this.intValue();
    }

    @Override
    public final int compareTo(Uint8 o) {
        return this.intValue() - o.intValue();
    }

    @Override
    public final String toCanonicalString() {
        return String.valueOf(this.intValue());
    }

    @Override
    public final CanonicalValueSupport<Uint8> support() {
        return SUPPORT;
    }

    public final int hashCode() {
        return Byte.hashCode(this.value);
    }

    public final boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Uint8 && this.value == ((Uint8)obj).value;
    }

    public final String toString() {
        return this.toCanonicalString();
    }

    private Object readResolve() {
        return Uint8.instanceFor(this.value);
    }

    public static final class Support
    extends AbstractCanonicalValueSupport<Uint8> {
        public Support() {
            super(Uint8.class);
        }

        @Override
        public Variant<Uint8, CanonicalValueViolation> fromString(String str) {
            try {
                return Variant.ofFirst(Uint8.valueOf(str));
            }
            catch (IllegalArgumentException e) {
                return CanonicalValueViolation.variantOf(e);
            }
        }
    }
}

