/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.data.api.FixedYangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.StackedPathArguments;
import org.opendaylight.yangtools.yang.data.api.StackedReversePathArguments;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class StackedYangInstanceIdentifier
extends YangInstanceIdentifier
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Field PARENT_FIELD;
    private final YangInstanceIdentifier parent;
    private final YangInstanceIdentifier.PathArgument pathArgument;
    private volatile transient StackedPathArguments pathArguments;
    private volatile transient StackedReversePathArguments reversePathArguments;

    StackedYangInstanceIdentifier(YangInstanceIdentifier parent, YangInstanceIdentifier.PathArgument pathArgument, int hash) {
        super(hash);
        this.parent = Objects.requireNonNull(parent);
        this.pathArgument = Objects.requireNonNull(pathArgument);
    }

    public StackedYangInstanceIdentifier clone() {
        try {
            return (StackedYangInstanceIdentifier)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("clone() should be supported", e);
        }
    }

    @Override
    public YangInstanceIdentifier getParent() {
        return this.parent;
    }

    @Override
    @Nonnull
    public YangInstanceIdentifier getAncestor(int depth) {
        Preconditions.checkArgument(depth >= 0, "Steps cannot be negative");
        int stackedDepth = 1;
        YangInstanceIdentifier wlk = this.getParent();
        while (wlk instanceof StackedYangInstanceIdentifier) {
            wlk = wlk.getParent();
            ++stackedDepth;
        }
        int fixedDepth = wlk.getPathArguments().size();
        if (fixedDepth >= depth) {
            return wlk.getAncestor(depth);
        }
        int ourDepth = stackedDepth + fixedDepth;
        Preconditions.checkArgument(depth <= ourDepth, "Depth %s exceeds maximum depth %s", depth, ourDepth);
        int toWalk = ourDepth - depth;
        YangInstanceIdentifier result = this;
        for (int i = 0; i < toWalk; ++i) {
            result = ((YangInstanceIdentifier)result).getParent();
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public List<YangInstanceIdentifier.PathArgument> getPathArguments() {
        StackedPathArguments ret = this.tryPathArguments();
        if (ret == null) {
            StackedYangInstanceIdentifier stacked;
            ArrayList<YangInstanceIdentifier.PathArgument> stack = new ArrayList<YangInstanceIdentifier.PathArgument>();
            YangInstanceIdentifier current = this;
            do {
                Verify.verify(current instanceof StackedYangInstanceIdentifier);
                stacked = current;
                stack.add(stacked.getLastPathArgument());
            } while ((current = stacked.getParent()).tryPathArguments() == null);
            this.pathArguments = ret = new StackedPathArguments(current, Lists.reverse(stack));
        }
        return ret;
    }

    @Override
    public List<YangInstanceIdentifier.PathArgument> getReversePathArguments() {
        StackedReversePathArguments ret = this.tryReversePathArguments();
        if (ret == null) {
            this.reversePathArguments = ret = new StackedReversePathArguments(this);
        }
        return ret;
    }

    @Override
    public YangInstanceIdentifier.PathArgument getLastPathArgument() {
        return this.pathArgument;
    }

    @Nonnull
    StackedPathArguments tryPathArguments() {
        return this.pathArguments;
    }

    @Nonnull
    StackedReversePathArguments tryReversePathArguments() {
        return this.reversePathArguments;
    }

    @Override
    @Nonnull
    YangInstanceIdentifier createRelativeIdentifier(int skipFromRoot) {
        return YangInstanceIdentifier.create(Iterables.skip(this.getPathArguments(), skipFromRoot));
    }

    @Override
    boolean pathArgumentsEqual(YangInstanceIdentifier other) {
        if (other instanceof StackedYangInstanceIdentifier) {
            StackedYangInstanceIdentifier stacked = (StackedYangInstanceIdentifier)other;
            return this.pathArgument.equals(stacked.pathArgument) && this.parent.equals(stacked.parent);
        }
        return super.pathArgumentsEqual(other);
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        FixedYangInstanceIdentifier p = (FixedYangInstanceIdentifier)inputStream.readObject();
        try {
            PARENT_FIELD.set(this, p);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IOException("Failed to set parent", e);
        }
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.defaultWriteObject();
        FixedYangInstanceIdentifier p = this.parent instanceof FixedYangInstanceIdentifier ? (FixedYangInstanceIdentifier)this.parent : FixedYangInstanceIdentifier.create(this.parent.getPathArguments(), this.parent.hashCode());
        outputStream.writeObject(p);
    }

    @Override
    public YangInstanceIdentifier toOptimized() {
        return FixedYangInstanceIdentifier.create(this.getPathArguments());
    }

    static {
        Field f;
        try {
            f = StackedYangInstanceIdentifier.class.getDeclaredField("parent");
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
        f.setAccessible(true);
        PARENT_FIELD = f;
    }
}

