/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree;

import com.google.common.annotations.Beta;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.api.schema.tree.EmptyDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.NormalizedNodeDataTreeCandidateNode;

@Beta
public final class DataTreeCandidateNodes {
    private DataTreeCandidateNodes() {
        throw new UnsupportedOperationException();
    }

    public static DataTreeCandidateNode empty(YangInstanceIdentifier.PathArgument identifier) {
        return new EmptyDataTreeCandidateNode(identifier);
    }

    public static DataTreeCandidateNode fromNormalizedNode(NormalizedNode<?, ?> node) {
        return new NormalizedNodeDataTreeCandidateNode(node);
    }

    public static void applyToCursor(DataTreeModificationCursor cursor, DataTreeCandidateNode node) {
        switch (node.getModificationType()) {
            case DELETE: {
                cursor.delete(node.getIdentifier());
                break;
            }
            case SUBTREE_MODIFIED: {
                cursor.enter(node.getIdentifier());
                AbstractNodeIterator iterator = new ExitingNodeIterator(null, node.getChildNodes().iterator());
                while ((iterator = iterator.next(cursor)) != null) {
                }
                break;
            }
            case UNMODIFIED: {
                break;
            }
            case WRITE: {
                cursor.write(node.getIdentifier(), node.getDataAfter().get());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modification " + (Object)((Object)node.getModificationType()));
            }
        }
    }

    public static void applyRootedNodeToCursor(DataTreeModificationCursor cursor, YangInstanceIdentifier rootPath, DataTreeCandidateNode node) {
        switch (node.getModificationType()) {
            case DELETE: {
                cursor.delete(rootPath.getLastPathArgument());
                break;
            }
            case SUBTREE_MODIFIED: {
                cursor.enter(rootPath.getLastPathArgument());
                AbstractNodeIterator iterator = new ExitingNodeIterator(null, node.getChildNodes().iterator());
                while ((iterator = iterator.next(cursor)) != null) {
                }
                break;
            }
            case UNMODIFIED: {
                break;
            }
            case WRITE: {
                cursor.write(rootPath.getLastPathArgument(), node.getDataAfter().get());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modification " + (Object)((Object)node.getModificationType()));
            }
        }
    }

    public static void applyRootToCursor(DataTreeModificationCursor cursor, DataTreeCandidateNode node) {
        switch (node.getModificationType()) {
            case DELETE: {
                throw new IllegalArgumentException("Can not delete root.");
            }
            case SUBTREE_MODIFIED: 
            case WRITE: {
                AbstractNodeIterator iterator = new RootNonExitingIterator(node.getChildNodes().iterator());
                while ((iterator = iterator.next(cursor)) != null) {
                }
                break;
            }
            case UNMODIFIED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modification " + (Object)((Object)node.getModificationType()));
            }
        }
    }

    private static final class ExitingNodeIterator
    extends AbstractNodeIterator {
        private final AbstractNodeIterator parent;

        ExitingNodeIterator(@Nullable AbstractNodeIterator parent, @Nonnull Iterator<DataTreeCandidateNode> iterator) {
            super(iterator);
            this.parent = parent;
        }

        @Override
        protected AbstractNodeIterator getParent() {
            return this.parent;
        }

        @Override
        protected void exitNode(DataTreeModificationCursor cursor) {
            cursor.exit();
        }
    }

    private static final class RootNonExitingIterator
    extends AbstractNodeIterator {
        protected RootNonExitingIterator(@Nonnull Iterator<DataTreeCandidateNode> iterator) {
            super(iterator);
        }

        @Override
        protected void exitNode(DataTreeModificationCursor cursor) {
        }

        @Override
        protected AbstractNodeIterator getParent() {
            return null;
        }
    }

    private static abstract class AbstractNodeIterator {
        private final Iterator<DataTreeCandidateNode> iterator;

        AbstractNodeIterator(Iterator<DataTreeCandidateNode> iterator) {
            this.iterator = Objects.requireNonNull(iterator);
        }

        AbstractNodeIterator next(DataTreeModificationCursor cursor) {
            block6: while (this.iterator.hasNext()) {
                DataTreeCandidateNode node = this.iterator.next();
                switch (node.getModificationType()) {
                    case DELETE: {
                        cursor.delete(node.getIdentifier());
                        continue block6;
                    }
                    case SUBTREE_MODIFIED: 
                    case APPEARED: 
                    case DISAPPEARED: {
                        Collection<DataTreeCandidateNode> children = node.getChildNodes();
                        if (children.isEmpty()) continue block6;
                        cursor.enter(node.getIdentifier());
                        return new ExitingNodeIterator(this, children.iterator());
                    }
                    case UNMODIFIED: {
                        continue block6;
                    }
                    case WRITE: {
                        cursor.write(node.getIdentifier(), node.getDataAfter().get());
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("Unsupported modification " + (Object)((Object)node.getModificationType()));
            }
            this.exitNode(cursor);
            return this.getParent();
        }

        @Nullable
        protected abstract AbstractNodeIterator getParent();

        protected abstract void exitNode(DataTreeModificationCursor var1);
    }
}

