/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.meta;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.ModelStatement;

public interface EffectiveStatement<A, D extends DeclaredStatement<A>>
extends ModelStatement<A> {
    @Nullable
    public D getDeclared();

    @Nullable
    public <K, V, N extends IdentifierNamespace<K, V>> V get(@Nonnull Class<N> var1, @Nonnull K var2);

    @Nullable
    public <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAll(@Nonnull Class<N> var1);

    default public <K, V, N extends IdentifierNamespace<K, V>> @NonNull Map<K, V> findAll(@NonNull Class<N> namespace) {
        Map<K, V> map = this.getAll(Objects.requireNonNull(namespace));
        return map == null ? ImmutableMap.of() : map;
    }

    @Nonnull
    public Collection<? extends EffectiveStatement<?, ?>> effectiveSubstatements();

    @Beta
    default public <T extends EffectiveStatement<?, ?>> Optional<T> findFirstEffectiveSubstatement(@Nonnull Class<T> type) {
        return this.effectiveSubstatements().stream().filter(type::isInstance).findFirst().map(type::cast);
    }

    @Beta
    default public <V, T extends EffectiveStatement<V, ?>> Optional<V> findFirstEffectiveSubstatementArgument(@Nonnull Class<T> type) {
        return this.findFirstEffectiveSubstatement(type).map(ModelStatement::argument);
    }

    @Beta
    default public <T extends EffectiveStatement<?, ?>> Stream<T> streamEffectiveSubstatements(@Nonnull Class<T> type) {
        return this.effectiveSubstatements().stream().filter(type::isInstance).map(type::cast);
    }
}

