/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.type;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.TypeDefinitions;

public interface EnumTypeDefinition
extends TypeDefinition<EnumTypeDefinition> {
    @Nonnull
    public List<EnumPair> getValues();

    public static boolean equals(EnumTypeDefinition type, Object obj) {
        if (type == obj) {
            return true;
        }
        EnumTypeDefinition other = TypeDefinitions.castIfEquals(EnumTypeDefinition.class, type, obj);
        return other != null && type.getValues().equals(other.getValues());
    }

    public static int hashCode(EnumTypeDefinition type) {
        return Objects.hash(type.getPath(), type.getUnknownSchemaNodes(), type.getBaseType(), type.getUnits().orElse(null), type.getDefaultValue(), type.getValues());
    }

    public static String toString(EnumTypeDefinition type) {
        return TypeDefinitions.toStringHelper(type).add("values", type.getValues()).toString();
    }

    public static interface EnumPair
    extends DocumentedNode.WithStatus {
        public String getName();

        public int getValue();
    }
}

