/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.type;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.RangeRestrictedTypeDefinition;

final class TypeDefinitions {
    private TypeDefinitions() {
        throw new UnsupportedOperationException();
    }

    static int basicHashCode(TypeDefinition<?> type) {
        return Objects.hash(type.getPath(), type.getUnknownSchemaNodes(), type.getBaseType(), type.getUnits().orElse(null), type.getDefaultValue().orElse(null));
    }

    static int hashCode(RangeRestrictedTypeDefinition<?, ?> type) {
        return Objects.hash(type.getPath(), type.getUnknownSchemaNodes(), type.getBaseType(), type.getUnits().orElse(null), type.getDefaultValue().orElse(null), type.getRangeConstraint().orElse(null));
    }

    static <T extends RangeRestrictedTypeDefinition<T, ?>> boolean equals(Class<T> clazz, T type, Object obj) {
        if (type == obj) {
            return true;
        }
        RangeRestrictedTypeDefinition other = (RangeRestrictedTypeDefinition)TypeDefinitions.castIfEquals(clazz, type, obj);
        return other != null && type.getRangeConstraint().equals(other.getRangeConstraint());
    }

    static String toString(RangeRestrictedTypeDefinition<?, ?> type) {
        return TypeDefinitions.toStringHelper(type).toString();
    }

    @Nullable
    static <T extends TypeDefinition<T>> T castIfEquals(Class<T> clazz, T type, Object obj) {
        if (!clazz.isInstance(obj)) {
            return null;
        }
        TypeDefinition other = (TypeDefinition)clazz.cast(obj);
        return (T)(Objects.equals(type.getPath(), other.getPath()) && Objects.equals(type.getBaseType(), other.getBaseType()) && Objects.equals(type.getDefaultValue(), other.getDefaultValue()) && Objects.equals(type.getUnknownSchemaNodes(), other.getUnknownSchemaNodes()) && Objects.equals(type.getUnits(), other.getUnits()) ? other : null);
    }

    static MoreObjects.ToStringHelper toStringHelper(TypeDefinition<?> type) {
        return MoreObjects.toStringHelper(type).omitNullValues().add("path", type.getPath()).add("baseType", type.getBaseType()).add("default", type.getDefaultValue().orElse(null)).add("description", type.getDescription().orElse(null)).add("reference", type.getReference().orElse(null)).add("status", (Object)type.getStatus()).add("units", type.getUnits().orElse(null));
    }

    static MoreObjects.ToStringHelper toStringHelper(RangeRestrictedTypeDefinition<?, ?> type) {
        return TypeDefinitions.toStringHelper(type).add("range", type.getRangeConstraint().orElse(null));
    }
}

