/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.base.MoreObjects;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YinTextSchemaSource;

final class DelegatedYinTextSchemaSource
extends YinTextSchemaSource
implements Delegator<ByteSource> {
    private final ByteSource delegate;

    DelegatedYinTextSchemaSource(SourceIdentifier identifier, ByteSource delegate) {
        super(identifier);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public ByteSource getDelegate() {
        return this.delegate;
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.delegate.openStream();
    }

    @Override
    public Optional<String> getSymbolicName() {
        return Optional.of("[" + this.delegate.toString() + "]");
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("delegate", this.delegate);
    }
}

