/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.annotations.Beta;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.Revision;

@Beta
public abstract class SourceIdentifier
implements Identifier,
Immutable {
    private static final Interner<SourceIdentifier> INTERNER = Interners.newWeakInterner();
    private static final long serialVersionUID = 2L;
    private final Revision revision;
    private final String name;

    SourceIdentifier(String name) {
        this(name, (Revision)null);
    }

    SourceIdentifier(String name, @Nullable Revision revision) {
        this.name = Objects.requireNonNull(name);
        this.revision = revision;
    }

    SourceIdentifier(String name, Optional<Revision> revision) {
        this(name, (Revision)revision.orElse(null));
    }

    public SourceIdentifier intern() {
        return INTERNER.intern(this);
    }

    public String getName() {
        return this.name;
    }

    public Optional<Revision> getRevision() {
        return Optional.ofNullable(this.revision);
    }

    public String toYangFilename() {
        return SourceIdentifier.toYangFileName(this.name, Optional.ofNullable(this.revision));
    }

    public static String toYangFileName(String moduleName, Optional<Revision> revision) {
        StringBuilder filename = new StringBuilder(moduleName);
        if (revision.isPresent()) {
            filename.append('@');
            filename.append(revision.get());
        }
        filename.append(".yang");
        return filename.toString();
    }
}

