/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.programming;

import java.math.BigInteger;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.Nanotime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NanotimeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NanotimeUtil.class);
    private static final BigInteger MILLION = BigInteger.valueOf(1000000L);
    private static volatile BigInteger nanoTimeOffset = null;

    private NanotimeUtil() {
        throw new UnsupportedOperationException();
    }

    public static Nanotime currentTime() {
        return new Nanotime(BigInteger.valueOf(System.currentTimeMillis()).multiply(MILLION));
    }

    public static Nanotime currentNanoTime() {
        if (nanoTimeOffset == null) {
            NanotimeUtil.calibrate();
        }
        return new Nanotime(BigInteger.valueOf(System.nanoTime()).add(nanoTimeOffset));
    }

    private static void calibrate() {
        long tm1 = System.currentTimeMillis();
        long nt1 = System.nanoTime();
        long tm2 = System.currentTimeMillis();
        long nt2 = System.nanoTime();
        LOG.debug("Calibrated currentTime and nanoTime to {}m <= {}n <= {}m <= {}n", tm1, nt1, tm2, nt2);
        BigInteger tm = BigInteger.valueOf(tm1).add(BigInteger.valueOf(tm2)).divide(BigInteger.valueOf(2L));
        BigInteger nt = BigInteger.valueOf(nt1).add(BigInteger.valueOf(nt2)).divide(BigInteger.valueOf(2L));
        nanoTimeOffset = tm.multiply(MILLION).subtract(nt);
    }
}

