/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.api;

import com.google.common.collect.Collections2;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.ChoiceIn;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public interface DataObjectModification<T extends DataObject>
extends org.opendaylight.yangtools.concepts.Identifiable<InstanceIdentifier.PathArgument> {
    @Override
    public InstanceIdentifier.PathArgument getIdentifier();

    public @NonNull Class<T> getDataType();

    public @NonNull ModificationType getModificationType();

    public @Nullable T getDataBefore();

    public @Nullable T getDataAfter();

    public @NonNull Collection<? extends DataObjectModification<? extends DataObject>> getModifiedChildren();

    default public <H extends ChoiceIn<? super T> & DataObject, C extends ChildOf<? super H>> Collection<DataObjectModification<C>> getModifiedChildren(@NonNull Class<H> caseType, @NonNull Class<C> childType) {
        InstanceIdentifier.Item item = InstanceIdentifier.Item.of(caseType, childType);
        return Collections2.filter(this.getModifiedChildren(), mod -> item.equals(mod.getIdentifier()));
    }

    default public <H extends ChoiceIn<? super T> & DataObject, C extends ChildOf<? super H>> @Nullable DataObjectModification<C> getModifiedChildContainer(@NonNull Class<H> caseType, @NonNull Class<C> child) {
        return this.getModifiedChild(InstanceIdentifier.Item.of(caseType, child));
    }

    public <C extends ChildOf<? super T>> @Nullable DataObjectModification<C> getModifiedChildContainer(@NonNull Class<C> var1);

    public <C extends Augmentation<T> & DataObject> @Nullable DataObjectModification<C> getModifiedAugmentation(@NonNull Class<C> var1);

    public <N extends Identifiable<K> & ChildOf<? super T>, K extends Identifier<N>> DataObjectModification<N> getModifiedChildListItem(@NonNull Class<N> var1, @NonNull K var2);

    default public <H extends ChoiceIn<? super T> & DataObject, C extends Identifiable<K> & ChildOf<? super H>, K extends Identifier<C>> DataObjectModification<C> getModifiedChildListItem(@NonNull Class<H> caseType, @NonNull Class<C> listItem, @NonNull K listKey) {
        return this.getModifiedChild(InstanceIdentifier.IdentifiableItem.of(caseType, listItem, listKey));
    }

    public @Nullable DataObjectModification<? extends DataObject> getModifiedChild(InstanceIdentifier.PathArgument var1);

    public static enum ModificationType {
        SUBTREE_MODIFIED,
        WRITE,
        DELETE;

    }
}

