/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.api;

import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public final class DataTreeIdentifier<T extends DataObject>
implements Immutable,
Path<DataTreeIdentifier<?>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final @NonNull InstanceIdentifier<T> rootIdentifier;
    private final @NonNull LogicalDatastoreType datastoreType;

    public DataTreeIdentifier(LogicalDatastoreType datastoreType, InstanceIdentifier<T> rootIdentifier) {
        this.datastoreType = Objects.requireNonNull(datastoreType);
        this.rootIdentifier = Objects.requireNonNull(rootIdentifier);
    }

    public @NonNull LogicalDatastoreType getDatastoreType() {
        return this.datastoreType;
    }

    public @NonNull InstanceIdentifier<T> getRootIdentifier() {
        return this.rootIdentifier;
    }

    @Override
    public boolean contains(DataTreeIdentifier<?> other) {
        return this.datastoreType == other.datastoreType && this.rootIdentifier.contains(other.rootIdentifier);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.datastoreType.hashCode();
        result = 31 * result + this.rootIdentifier.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataTreeIdentifier)) {
            return false;
        }
        DataTreeIdentifier other = (DataTreeIdentifier)obj;
        if (this.datastoreType != other.datastoreType) {
            return false;
        }
        return this.rootIdentifier.equals(other.rootIdentifier);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{datastoreType = " + (Object)((Object)this.datastoreType) + ", rootIdentifier = " + this.rootIdentifier + "}";
    }
}

