/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.api;

import com.google.common.util.concurrent.AbstractCheckedFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public final class MappingCheckedFuture<V, X extends Exception>
extends AbstractCheckedFuture<V, X> {
    private final Function<Exception, X> mapper;

    private MappingCheckedFuture(ListenableFuture<V> delegate, Function<Exception, X> mapper) {
        super(delegate);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public static <V, X extends Exception> MappingCheckedFuture<V, X> create(ListenableFuture<V> delegate, Function<Exception, X> mapper) {
        return new MappingCheckedFuture<V, X>(delegate, mapper);
    }

    @Override
    protected X mapException(Exception e) {
        return (X)((Exception)this.mapper.apply(e));
    }

    private ExecutionException wrapInExecutionException(String message, Exception ex) {
        return new ExecutionException(message, (Throwable)this.mapException(ex));
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return super.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.wrapInExecutionException("Operation was interrupted", e);
        }
        catch (CancellationException e) {
            throw this.wrapInExecutionException("Operation was cancelled", e);
        }
        catch (ExecutionException e) {
            throw this.wrapInExecutionException(e.getMessage(), e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return super.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.wrapInExecutionException("Operation was interrupted", e);
        }
        catch (CancellationException e) {
            throw this.wrapInExecutionException("Operation was cancelled", e);
        }
        catch (ExecutionException e) {
            throw this.wrapInExecutionException(e.getMessage(), e);
        }
    }
}

