/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.api;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class AbstractBrokerAwareActivator
implements BundleActivator {
    private static final ExecutorService MD_ACTIVATION_POOL = Executors.newCachedThreadPool();
    private ServiceTracker<BindingAwareBroker, BindingAwareBroker> tracker;

    public final void start(BundleContext bundleContext) {
        this.startImpl(bundleContext);
        this.tracker = new ServiceTracker(bundleContext, BindingAwareBroker.class, (ServiceTrackerCustomizer)new Customizer(bundleContext));
        this.tracker.open();
    }

    public final void stop(BundleContext bundleContext) {
        if (this.tracker != null) {
            this.tracker.close();
        }
        this.stopImpl(bundleContext);
    }

    protected void startImpl(BundleContext bundleContext) {
    }

    protected void stopImpl(BundleContext bundleContext) {
    }

    protected abstract void onBrokerAvailable(BindingAwareBroker var1, BundleContext var2);

    protected void onBrokerRemoved(BindingAwareBroker bindingBroker, BundleContext bundleContext) {
        this.stopImpl(bundleContext);
    }

    private final class Customizer
    implements ServiceTrackerCustomizer<BindingAwareBroker, BindingAwareBroker> {
        private final BundleContext context;

        Customizer(BundleContext context) {
            this.context = Objects.requireNonNull(context);
        }

        public BindingAwareBroker addingService(ServiceReference<BindingAwareBroker> reference) {
            BindingAwareBroker broker = (BindingAwareBroker)this.context.getService(reference);
            MD_ACTIVATION_POOL.execute(() -> AbstractBrokerAwareActivator.this.onBrokerAvailable(broker, this.context));
            return broker;
        }

        public void modifiedService(ServiceReference<BindingAwareBroker> reference, BindingAwareBroker service) {
            this.removedService(reference, service);
            this.addingService((ServiceReference)reference);
        }

        public void removedService(ServiceReference<BindingAwareBroker> reference, BindingAwareBroker service) {
            BindingAwareBroker broker = (BindingAwareBroker)this.context.getService(reference);
            MD_ACTIVATION_POOL.execute(() -> AbstractBrokerAwareActivator.this.onBrokerRemoved(broker, this.context));
        }
    }
}

