/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.spec.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;

@Beta
public final class DataObjectReadingUtil {
    private static final DataObjectReadingStrategy REAUSABLE_AUGMENTATION_READING_STRATEGY = new AugmentationReadingStrategy();

    private DataObjectReadingUtil() {
        throw new UnsupportedOperationException("Utility class. Instantion is not allowed.");
    }

    public static <T extends DataObject, P extends DataObject> Map<InstanceIdentifier<T>, T> readData(P parent, InstanceIdentifier<P> parentPath, InstanceIdentifier<T> childPath) {
        Preconditions.checkArgument(parent != null, "Parent must not be null.");
        Preconditions.checkArgument(parentPath != null, "Parent path must not be null");
        Preconditions.checkArgument(childPath != null, "Child path must not be null");
        Preconditions.checkArgument(parentPath.containsWildcarded(childPath), "Parent object must be parent of child.");
        List<InstanceIdentifier.PathArgument> pathArgs = DataObjectReadingUtil.subList(parentPath.getPathArguments(), childPath.getPathArguments());
        Map<InstanceIdentifier<P>, P> lastFound = Collections.singletonMap(parentPath, parent);
        for (InstanceIdentifier.PathArgument pathArgument : pathArgs) {
            ImmutableMap.Builder<InstanceIdentifier, DataContainer> potentialBuilder = ImmutableMap.builder();
            for (Map.Entry<InstanceIdentifier, DataContainer> entry : lastFound.entrySet()) {
                potentialBuilder.putAll(DataObjectReadingUtil.readData(entry, pathArgument));
            }
            lastFound = potentialBuilder.build();
            if (!lastFound.isEmpty()) continue;
            return Collections.emptyMap();
        }
        Map<InstanceIdentifier<P>, P> result = lastFound;
        return result;
    }

    private static Map<InstanceIdentifier, DataContainer> readData(Map.Entry<InstanceIdentifier, DataContainer> entry, InstanceIdentifier.PathArgument pathArgument) {
        return DataObjectReadingUtil.readData(entry.getValue(), entry.getKey(), pathArgument);
    }

    public static <T extends DataObject> Optional<T> readData(DataObject source, Class<T> child) {
        Preconditions.checkArgument(source != null, "Object should not be null.");
        Preconditions.checkArgument(child != null, "Child type should not be null");
        Class<? extends DataContainer> parentClass = source.getImplementedInterface();
        DataObject potential = (DataObject)DataObjectReadingUtil.resolveReadStrategy(parentClass, child).read(source, child);
        return Optional.ofNullable(potential);
    }

    private static Map<InstanceIdentifier, DataContainer> readData(DataContainer parent, InstanceIdentifier parentPath, InstanceIdentifier.PathArgument child) {
        Preconditions.checkArgument(parent != null, "Object should not be null.");
        Preconditions.checkArgument(child != null, "Child argument should not be null");
        Class<? extends DataContainer> parentClass = parent.getImplementedInterface();
        return DataObjectReadingUtil.resolveReadStrategy(parentClass, child.getType()).readUsingPathArgument(parent, child, parentPath);
    }

    private static DataObjectReadingStrategy resolveReadStrategy(Class<? extends DataContainer> parentClass, Class<? extends DataContainer> type) {
        return DataObjectReadingUtil.createReadStrategy(parentClass, type);
    }

    private static DataObjectReadingStrategy createReadStrategy(Class<? extends DataContainer> parent, Class<? extends DataContainer> child) {
        if (Augmentable.class.isAssignableFrom(parent) && Augmentation.class.isAssignableFrom(child)) {
            return REAUSABLE_AUGMENTATION_READING_STRATEGY;
        }
        if (Identifiable.class.isAssignableFrom(child)) {
            Class<? extends DataContainer> identifiableClass = child;
            return new ListItemReadingStrategy(parent, identifiableClass);
        }
        return new ContainerReadingStrategy(parent, child);
    }

    private static <P, C> List<C> subList(Iterable<P> parent, Iterable<C> child) {
        Iterator<P> parentIt = parent.iterator();
        ArrayList<C> result = new ArrayList<C>();
        for (C arg : child) {
            if (parentIt.hasNext()) {
                parentIt.next();
                continue;
            }
            result.add(arg);
        }
        if (parentIt.hasNext()) {
            throw new IllegalArgumentException("Parent argument is bigger than child.");
        }
        return result;
    }

    private static final class AugmentationReadingStrategy
    extends DataObjectReadingStrategy {
        AugmentationReadingStrategy() {
            super(Augmentable.class, Augmentation.class, null);
        }

        @Override
        public Map<InstanceIdentifier, DataContainer> readUsingPathArgument(DataContainer parent, InstanceIdentifier.PathArgument childArgument, InstanceIdentifier builder) {
            Preconditions.checkArgument(childArgument instanceof InstanceIdentifier.Item, "Path Argument must be Item without keys");
            DataContainer aug = this.read(parent, childArgument.getType());
            if (aug == null) {
                return Collections.emptyMap();
            }
            InstanceIdentifier<? extends DataObject> childPath = builder.child(childArgument.getType());
            return Collections.singletonMap(childPath, aug);
        }

        @Override
        public DataContainer read(DataContainer parent, Class<?> child) {
            Preconditions.checkArgument(Augmentation.class.isAssignableFrom(child), "Child must be Augmentation.");
            Preconditions.checkArgument(parent instanceof Augmentable, "Parent must be Augmentable.");
            Object potential = ((Augmentable)((Object)parent)).augmentation(child);
            Preconditions.checkState(potential instanceof DataContainer, "Readed augmention must be data object");
            return (DataContainer)potential;
        }
    }

    private static final class ListItemReadingStrategy
    extends DataObjectReadingStrategy {
        ListItemReadingStrategy(Class<? extends DataContainer> parent, Class child) {
            super(parent, child);
            Preconditions.checkArgument(Iterable.class.isAssignableFrom(this.getGetterMethod().getReturnType()));
        }

        @Override
        public DataContainer read(DataContainer parent, Class<?> child) {
            return null;
        }

        @Override
        public Map<InstanceIdentifier, DataContainer> readUsingPathArgument(DataContainer parent, InstanceIdentifier.PathArgument childArgument, InstanceIdentifier builder) {
            try {
                Object potentialList = this.getGetterMethod().invoke((Object)parent, new Object[0]);
                if (potentialList instanceof Iterable) {
                    Iterable dataList = (Iterable)potentialList;
                    return childArgument instanceof InstanceIdentifier.IdentifiableItem ? ListItemReadingStrategy.readUsingIdentifiableItem(dataList, (InstanceIdentifier.IdentifiableItem)childArgument, builder) : this.readAll(dataList, builder);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
            return Collections.emptyMap();
        }

        private Map<InstanceIdentifier, DataContainer> readAll(Iterable<Identifiable> dataList, InstanceIdentifier parentPath) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (Identifiable item : dataList) {
                KeyedInstanceIdentifier childPath = parentPath.child(this.getChildType(), item.key());
                result.put(childPath, (DataContainer)((Object)item));
            }
            return result.build();
        }

        private static Map<InstanceIdentifier, DataContainer> readUsingIdentifiableItem(Iterable<Identifiable> dataList, InstanceIdentifier.IdentifiableItem childArgument, InstanceIdentifier parentPath) {
            Object key = childArgument.getKey();
            for (Identifiable item : dataList) {
                if (!key.equals(item.key()) || !(item instanceof DataContainer)) continue;
                Preconditions.checkState(childArgument.getType().isInstance(item), "Found child is not instance of requested type");
                KeyedInstanceIdentifier childPath = parentPath.child(childArgument.getType(), item.key());
                return Collections.singletonMap(childPath, (DataContainer)((Object)item));
            }
            return Collections.emptyMap();
        }
    }

    private static final class ContainerReadingStrategy
    extends DataObjectReadingStrategy {
        ContainerReadingStrategy(Class<? extends DataContainer> parent, Class<? extends DataContainer> child) {
            super(parent, child);
            Preconditions.checkArgument(child.isAssignableFrom(this.getGetterMethod().getReturnType()));
        }

        @Override
        public Map<InstanceIdentifier, DataContainer> readUsingPathArgument(DataContainer parent, InstanceIdentifier.PathArgument childArgument, InstanceIdentifier parentPath) {
            DataContainer result = this.read(parent, childArgument.getType());
            if (result != null) {
                InstanceIdentifier<? extends DataObject> childPath = parentPath.child(childArgument.getType());
                return Collections.singletonMap(childPath, result);
            }
            return Collections.emptyMap();
        }

        @Override
        public DataContainer read(DataContainer parent, Class<?> child) {
            try {
                Object potentialData = this.getGetterMethod().invoke((Object)parent, new Object[0]);
                Preconditions.checkState(potentialData instanceof DataContainer);
                return (DataContainer)potentialData;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static abstract class DataObjectReadingStrategy {
        private final Class<? extends DataContainer> parentType;
        private final Class<? extends DataContainer> childType;
        private final Method getterMethod;

        DataObjectReadingStrategy(Class parentType, Class childType) {
            Preconditions.checkArgument(DataContainer.class.isAssignableFrom(parentType));
            Preconditions.checkArgument(DataContainer.class.isAssignableFrom(childType));
            this.parentType = parentType;
            this.childType = childType;
            this.getterMethod = DataObjectReadingStrategy.resolveGetterMethod(parentType, childType);
        }

        DataObjectReadingStrategy(Class parentType, Class childType, Method getter) {
            this.parentType = parentType;
            this.childType = childType;
            this.getterMethod = getter;
        }

        protected Class<? extends DataContainer> getParentType() {
            return this.parentType;
        }

        protected Class<? extends DataContainer> getChildType() {
            return this.childType;
        }

        protected Method getGetterMethod() {
            return this.getterMethod;
        }

        public abstract Map<InstanceIdentifier, DataContainer> readUsingPathArgument(DataContainer var1, InstanceIdentifier.PathArgument var2, InstanceIdentifier var3);

        public abstract DataContainer read(DataContainer var1, Class<?> var2);

        private static Method resolveGetterMethod(Class<? extends DataContainer> parent, Class<?> child) {
            String methodName = "get" + child.getSimpleName();
            try {
                return parent.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            catch (SecurityException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

