/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.concepts;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MultiRegistry<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(MultiRegistry.class);
    private final ConcurrentMap<K, V> current = new ConcurrentHashMap();
    @GuardedBy(value="this")
    private final ListMultimap<K, V> candidates = ArrayListMultimap.create();

    @GuardedBy(value="this")
    private void updateCurrent(K key) {
        Collection values = this.candidates.get((Object)key);
        if (values.isEmpty()) {
            this.current.remove(key);
            return;
        }
        Object best = values.get(0);
        for (Object v : values) {
            Class<?> vc = v.getClass();
            Class<?> bc = best.getClass();
            if (bc.isAssignableFrom(vc)) {
                LOG.debug("{} is superclass of {}, preferring the latter", (Object)bc, (Object)vc);
                best = v;
                continue;
            }
            if (vc.isAssignableFrom(bc)) {
                LOG.debug("{} is subclass of {}, preferring the former", (Object)bc, (Object)vc);
                continue;
            }
            LOG.debug("{} and {} are not related, keeping the former", (Object)bc, (Object)vc);
        }
        LOG.debug("New best value {}", best);
        this.current.put(key, best);
    }

    public synchronized Registration register(final K key, final V value) {
        this.candidates.put(key, value);
        this.updateCurrent(key);
        return new AbstractRegistration(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void removeRegistration() {
                MultiRegistry multiRegistry = MultiRegistry.this;
                synchronized (multiRegistry) {
                    MultiRegistry.this.candidates.remove(key, value);
                    MultiRegistry.this.updateCurrent(key);
                }
            }
        };
    }

    public V get(K key) {
        return this.current.get(key);
    }

    public Iterable<V> getAllValues() {
        return Iterables.unmodifiableIterable(this.current.values());
    }
}

