/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.initiated00;

import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.pcep.ietf.stateful07.Stateful07LspObjectParser;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev181109.Lsp1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev181109.Lsp1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.OperationalStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.object.Lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.object.LspBuilder;

public class CInitiated00LspObjectParser
extends Stateful07LspObjectParser {
    private static final int CREATE_FLAG_OFFSET = 4;

    public CInitiated00LspObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg);
    }

    @Override
    protected void parseFlags(LspBuilder builder, ByteBuf bytes) {
        BitArray flags = BitArray.valueOf(bytes, 12);
        builder.setDelegate(flags.get(11));
        builder.setSync(flags.get(10));
        builder.setRemove(flags.get(9));
        builder.setAdministrative(flags.get(8));
        builder.addAugmentation(Lsp1.class, new Lsp1Builder().setCreate(flags.get(4)).build());
        short s2 = 0;
        s2 = (short)(s2 | (flags.get(7) ? 1 : 0));
        s2 = (short)(s2 | (flags.get(6) ? 1 : 0) << 1);
        s2 = (short)(s2 | (flags.get(5) ? 1 : 0) << 2);
        builder.setOperational(OperationalStatus.forValue(s2));
    }

    @Override
    protected BitArray serializeFlags(Lsp specObj) {
        BitArray flags = new BitArray(12);
        flags.set(11, specObj.isDelegate());
        flags.set(9, specObj.isRemove());
        flags.set(10, specObj.isSync());
        flags.set(8, specObj.isAdministrative());
        if (specObj.augmentation(Lsp1.class) != null) {
            flags.set(4, specObj.augmentation(Lsp1.class).isCreate());
        }
        return flags;
    }
}

