/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.initiated00;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev181109.Pcinitiate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev181109.PcinitiateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev181109.pcinitiate.message.PcinitiateMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev181109.pcinitiate.message.PcinitiateMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev181109.pcinitiate.message.pcinitiate.message.Requests;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev181109.pcinitiate.message.pcinitiate.message.RequestsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.object.Lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.srp.object.Srp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.object.EndpointsObj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lsp.attributes.MetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.Metric;

public class CInitiated00PCInitiateMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 12;

    public CInitiated00PCInitiateMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument(message instanceof Pcinitiate, "Wrong instance of Message. Passed instance of %s. Need PcinitiateMessage.", message.getClass());
        PcinitiateMessage init = ((Pcinitiate)message).getPcinitiateMessage();
        ByteBuf buffer = Unpooled.buffer();
        for (Requests req : init.getRequests()) {
            this.serializeRequest(req, buffer);
        }
        MessageUtil.formatMessage(12, buffer, out);
    }

    protected void serializeRequest(Requests req, ByteBuf buffer) {
        this.serializeObject(req.getSrp(), buffer);
        this.serializeObject(req.getLsp(), buffer);
        this.serializeObject(req.getEndpointsObj(), buffer);
        this.serializeObject(req.getEro(), buffer);
        this.serializeObject(req.getLspa(), buffer);
        this.serializeObject(req.getBandwidth(), buffer);
        if (req.getMetrics() != null) {
            for (Metrics m3 : req.getMetrics()) {
                this.serializeObject(m3.getMetric(), buffer);
            }
        }
        this.serializeObject(req.getIro(), buffer);
    }

    @Override
    protected Message validate(List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects, List<Message> errors) throws PCEPDeserializerException {
        Preconditions.checkArgument(objects != null, "Passed list can't be null.");
        PcinitiateMessageBuilder builder = new PcinitiateMessageBuilder();
        ArrayList<Requests> reqs = Lists.newArrayList();
        while (!objects.isEmpty()) {
            reqs.add(this.getValidRequest(objects));
        }
        builder.setRequests(reqs);
        return new PcinitiateBuilder().setPcinitiateMessage(builder.build()).build();
    }

    protected Requests getValidRequest(List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects) {
        RequestsBuilder builder = new RequestsBuilder();
        builder.setSrp((Srp)objects.get(0));
        objects.remove(0);
        builder.setLsp((Lsp)objects.get(0));
        objects.remove(0);
        ArrayList<Metrics> metrics = Lists.newArrayList();
        State state = State.INIT;
        while (!objects.isEmpty() && !state.equals((Object)State.END)) {
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj = objects.get(0);
            if ((state = CInitiated00PCInitiateMessageParser.insertObject(state, obj, builder, metrics)).equals((Object)State.END)) continue;
            objects.remove(0);
        }
        builder.setMetrics(metrics);
        return builder.build();
    }

    private static State insertObject(State state, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj, RequestsBuilder builder, List<Metrics> metrics) {
        switch (state) {
            case INIT: {
                if (obj instanceof EndpointsObj) {
                    builder.setEndpointsObj((EndpointsObj)obj);
                    return State.ENDPOINTS_IN;
                }
            }
            case ENDPOINTS_IN: {
                if (obj instanceof Ero) {
                    builder.setEro((Ero)obj);
                    return State.ERO_IN;
                }
            }
            case ERO_IN: {
                if (obj instanceof Lspa) {
                    builder.setLspa((Lspa)obj);
                    return State.LSPA_IN;
                }
            }
            case LSPA_IN: {
                if (obj instanceof Bandwidth) {
                    builder.setBandwidth((Bandwidth)obj);
                    return State.BANDWIDTH_IN;
                }
            }
            case BANDWIDTH_IN: {
                if (obj instanceof Metric) {
                    metrics.add(new MetricsBuilder().setMetric((Metric)obj).build());
                    return State.BANDWIDTH_IN;
                }
            }
            case METRIC_IN: {
                if (obj instanceof Iro) {
                    builder.setIro((Iro)obj);
                    return State.IRO_IN;
                }
            }
            case IRO_IN: 
            case END: {
                return State.END;
            }
        }
        return state;
    }

    private static enum State {
        INIT,
        ENDPOINTS_IN,
        ERO_IN,
        LSPA_IN,
        BANDWIDTH_IN,
        METRIC_IN,
        IRO_IN,
        END;

    }
}

