/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful07;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Map;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.MplsLabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.PathBinding;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.PathBindingBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.path.binding.BindingTypeValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.path.binding.binding.type.value.MplsLabelBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.path.binding.binding.type.value.MplsLabelEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.path.binding.binding.type.value.MplsLabelEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yangtools.concepts.Codec;

public final class PathBindingTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 31;
    private static final int MPLS_LABEL = 0;
    private static final int MPLS_STACK_ENTRY = 1;
    private static final int LABEL_MASK = 1048575;
    private static final int TC_MASK = 7;
    private static final int S_MASK = 1;
    private static final int TTL_MASK = 255;
    private static final int LABEL_SHIFT = 12;
    private static final int TC_SHIFT = 9;
    private static final int S_SHIFT = 8;
    private static final int MPLS_ENTRY_LENGTH = 4;
    private static final int MPLS_BINDING_LENGTH = 6;
    private static final Map<Integer, PathBindingTlvCodec> BT_PARSERS;
    private static final Map<Class<? extends BindingTypeValue>, PathBindingTlvCodec> BT_SERIALIZERS;

    @Override
    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument(tlv instanceof PathBinding, "The TLV must be PathBinding type, but was %s", tlv.getClass());
        PathBinding pTlv = (PathBinding)tlv;
        BindingTypeValue bindingTypeValue = pTlv.getBindingTypeValue();
        Preconditions.checkArgument(bindingTypeValue != null, "Missing Binding Value in Path Bidning TLV: %s", (Object)pTlv);
        ByteBuf body = Unpooled.buffer(6);
        PathBindingTlvCodec codec = BT_SERIALIZERS.get(bindingTypeValue.getImplementedInterface());
        Preconditions.checkArgument(codec != null, "Unsupported Path Binding Type: %s", bindingTypeValue.getImplementedInterface());
        ByteBufWriteUtil.writeUnsignedShort(codec.getBindingType(), body);
        body.writeBytes((ByteBuf)codec.serialize(bindingTypeValue));
        TlvUtil.formatTlv(31, body, buffer);
    }

    @Override
    public Tlv parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        int type = buffer.readUnsignedShort();
        PathBindingTlvCodec codec = BT_PARSERS.get(type);
        if (codec == null) {
            throw new PCEPDeserializerException("Unsupported Path Binding Type: " + type);
        }
        return new PathBindingBuilder().setBindingTypeValue((BindingTypeValue)codec.deserialize(buffer)).build();
    }

    private static MplsLabel getMplsLabel(long mplsStackEntry) {
        return new MplsLabel(mplsStackEntry >> 12 & 0xFFFFFL);
    }

    private static long getMplsStackEntry(MplsLabel mplsLabel) {
        return mplsLabel.getValue() << 12;
    }

    static {
        MplsLabelCodec mplsLabelCodec = new MplsLabelCodec();
        MplsLabelEntryCodec mplsLabelEntryCodec = new MplsLabelEntryCodec();
        ImmutableMap.Builder<Integer, PathBindingTlvCodec> parsers = ImmutableMap.builder();
        ImmutableMap.Builder<Class, PathBindingTlvCodec> serializers = ImmutableMap.builder();
        parsers.put(mplsLabelCodec.getBindingType(), mplsLabelCodec);
        serializers.put(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.path.binding.binding.type.value.MplsLabel.class, mplsLabelCodec);
        parsers.put(mplsLabelEntryCodec.getBindingType(), mplsLabelEntryCodec);
        serializers.put(MplsLabelEntry.class, mplsLabelEntryCodec);
        BT_PARSERS = parsers.build();
        BT_SERIALIZERS = serializers.build();
    }

    private static interface PathBindingTlvCodec
    extends Codec<ByteBuf, BindingTypeValue> {
        public int getBindingType();
    }

    private static final class MplsLabelEntryCodec
    implements PathBindingTlvCodec {
        private MplsLabelEntryCodec() {
        }

        @Override
        public ByteBuf serialize(BindingTypeValue bindingValue) {
            Preconditions.checkArgument(bindingValue instanceof MplsLabelEntry, "bindingValue is not MplsLabelEntry");
            MplsLabelEntry mplsEntry = (MplsLabelEntry)bindingValue;
            ByteBuf value = Unpooled.buffer(4);
            long entry = PathBindingTlvParser.getMplsStackEntry(mplsEntry.getLabel()) | (long)(mplsEntry.getTrafficClass() << 9) | (long)((mplsEntry.isBottomOfStack() != false ? 1 : 0) << 8) | (long)mplsEntry.getTimeToLive().shortValue();
            ByteBufWriteUtil.writeUnsignedInt(entry, value);
            return value;
        }

        @Override
        public BindingTypeValue deserialize(ByteBuf buffer) {
            MplsLabelEntryBuilder builder = new MplsLabelEntryBuilder();
            long entry = buffer.readUnsignedInt();
            builder.setLabel(PathBindingTlvParser.getMplsLabel(entry));
            builder.setTrafficClass((short)(entry >> 9 & 7L));
            builder.setBottomOfStack((entry >> 8 & 1L) == 1L);
            builder.setTimeToLive((short)(entry & 0xFFL));
            return builder.build();
        }

        @Override
        public int getBindingType() {
            return 1;
        }
    }

    private static final class MplsLabelCodec
    implements PathBindingTlvCodec {
        private MplsLabelCodec() {
        }

        @Override
        public ByteBuf serialize(BindingTypeValue bindingValue) {
            Preconditions.checkArgument(bindingValue instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.path.binding.binding.type.value.MplsLabel, "bindingValue is not MplsLabel");
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.path.binding.binding.type.value.MplsLabel mplsLabel = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.path.binding.tlv.path.binding.binding.type.value.MplsLabel)bindingValue;
            ByteBuf value = Unpooled.buffer(4);
            ByteBufWriteUtil.writeUnsignedInt(PathBindingTlvParser.getMplsStackEntry(mplsLabel.getMplsLabel()), value);
            return value;
        }

        @Override
        public BindingTypeValue deserialize(ByteBuf buffer) {
            MplsLabelBuilder builder = new MplsLabelBuilder();
            builder.setMplsLabel(PathBindingTlvParser.getMplsLabel(buffer.readUnsignedInt()));
            return builder.build();
        }

        @Override
        public int getBindingType() {
            return 0;
        }
    }
}

