/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful07;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.error.code.tlv.LspErrorCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.lsp.error.code.tlv.LspErrorCodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;

public final class Stateful07LspUpdateErrorTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 20;
    private static final int CONTENT_LENGTH = 4;

    @Override
    public LspErrorCode parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        return new LspErrorCodeBuilder().setErrorCode(buffer.readUnsignedInt()).build();
    }

    @Override
    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument(tlv instanceof LspErrorCode, "LspErrorCodeTlv is mandatory.");
        ByteBuf body = Unpooled.buffer(4);
        ByteBufWriteUtil.writeUnsignedInt(((LspErrorCode)tlv).getErrorCode(), body);
        TlvUtil.formatTlv(20, body, buffer);
    }
}

