/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful07;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.SrpIdNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.srp.object.Srp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.srp.object.SrpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.srp.object.srp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.srp.object.srp.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.symbolic.path.name.tlv.SymbolicPathName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.setup.type.tlv.PathSetupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;

public class Stateful07SrpObjectParser
extends AbstractObjectWithTlvsParser<TlvsBuilder> {
    private static final int CLASS = 33;
    private static final int TYPE = 1;
    protected static final int FLAGS_SIZE = 32;
    protected static final int SRP_ID_SIZE = 4;
    protected static final int MIN_SIZE = 8;

    protected Stateful07SrpObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg, 33, 1);
    }

    @Override
    public Srp parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        if (bytes.readableBytes() < 8) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + bytes.readableBytes() + "; Expected: >=" + 8 + ".");
        }
        SrpBuilder builder = new SrpBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        this.parseFlags(builder, bytes);
        builder.setOperationId(new SrpIdNumber(bytes.readUnsignedInt()));
        TlvsBuilder tlvsBuilder = new TlvsBuilder();
        this.parseTlvs(tlvsBuilder, bytes.slice());
        builder.setTlvs(tlvsBuilder.build());
        return builder.build();
    }

    protected void parseFlags(SrpBuilder builder, ByteBuf bytes) {
        bytes.skipBytes(4);
    }

    @Override
    public void addTlv(TlvsBuilder builder, Tlv tlv) {
        if (tlv instanceof SymbolicPathName) {
            builder.setSymbolicPathName((SymbolicPathName)tlv);
        }
        if (tlv instanceof PathSetupType) {
            builder.setPathSetupType((PathSetupType)tlv);
        }
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof Srp, "Wrong instance of PCEPObject. Passed %s . Needed SrpObject.", object.getClass());
        Srp srp = (Srp)object;
        ByteBuf body = Unpooled.buffer();
        this.serializeFlags(srp, body);
        SrpIdNumber srpId = srp.getOperationId();
        Preconditions.checkArgument(srpId != null, "SrpId is mandatory.");
        ByteBufWriteUtil.writeUnsignedInt(srpId.getValue(), body);
        this.serializeTlvs(srp.getTlvs(), body);
        ObjectUtil.formatSubobject(1, 33, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }

    protected void serializeFlags(Srp srp, ByteBuf body) {
        body.writeZero(4);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs == null) {
            return;
        }
        if (tlvs.getSymbolicPathName() != null) {
            this.serializeTlv(tlvs.getSymbolicPathName(), body);
        }
        if (tlvs.getPathSetupType() != null) {
            this.serializeTlv(tlvs.getPathSetupType(), body);
        }
    }

    @Override
    protected final void addVendorInformationTlvs(TlvsBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setVendorInformationTlv(tlvs);
        }
    }
}

