/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.protocol.concepts.KeyMapping;
import org.opendaylight.protocol.pcep.PCEPDispatcher;
import org.opendaylight.protocol.pcep.PCEPDispatcherDependencies;
import org.opendaylight.protocol.pcep.PCEPSessionNegotiatorFactory;
import org.opendaylight.protocol.pcep.impl.PCEPHandlerFactory;
import org.opendaylight.protocol.pcep.impl.PCEPSessionImpl;
import org.opendaylight.protocol.pcep.spi.MessageRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEPDispatcherImpl
implements PCEPDispatcher,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PCEPDispatcherImpl.class);
    private static final Integer SOCKET_BACKLOG_SIZE = 128;
    private static final long TIMEOUT = 10L;
    private final PCEPSessionNegotiatorFactory<PCEPSessionImpl> snf;
    private final PCEPHandlerFactory hf;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final EventExecutor executor;
    @GuardedBy(value="this")
    private KeyMapping keys;

    public PCEPDispatcherImpl(@Nonnull MessageRegistry registry, @Nonnull PCEPSessionNegotiatorFactory<PCEPSessionImpl> negotiatorFactory, @Nonnull EventLoopGroup bossGroup, @Nonnull EventLoopGroup workerGroup) {
        this.snf = Objects.requireNonNull(negotiatorFactory);
        this.hf = new PCEPHandlerFactory(registry);
        if (Epoll.isAvailable()) {
            this.bossGroup = new EpollEventLoopGroup();
            this.workerGroup = new EpollEventLoopGroup();
        } else {
            this.bossGroup = Objects.requireNonNull(bossGroup);
            this.workerGroup = Objects.requireNonNull(workerGroup);
        }
        this.executor = Objects.requireNonNull(GlobalEventExecutor.INSTANCE);
    }

    @Override
    public final synchronized ChannelFuture createServer(PCEPDispatcherDependencies dispatcherDependencies) {
        this.keys = dispatcherDependencies.getKeys();
        ChannelPipelineInitializer initializer = (ch, promise) -> {
            ch.pipeline().addLast(this.hf.getDecoders());
            ch.pipeline().addLast("negotiator", (ChannelHandler)this.snf.getSessionNegotiator(dispatcherDependencies, ch, promise));
            ch.pipeline().addLast(this.hf.getEncoders());
        };
        ServerBootstrap b = this.createServerBootstrap(initializer);
        InetSocketAddress address = dispatcherDependencies.getAddress();
        ChannelFuture f = b.bind(address);
        LOG.debug("Initiated server {} at {}.", (Object)f, (Object)address);
        this.keys = KeyMapping.getKeyMapping();
        return f;
    }

    synchronized ServerBootstrap createServerBootstrap(final ChannelPipelineInitializer initializer) {
        ServerBootstrap b = new ServerBootstrap();
        b.childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) {
                initializer.initializeChannel(ch, new DefaultPromise<PCEPSessionImpl>(PCEPDispatcherImpl.this.executor));
            }
        });
        b.option(ChannelOption.SO_BACKLOG, SOCKET_BACKLOG_SIZE);
        b.childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        if (Epoll.isAvailable()) {
            b.channel(EpollServerSocketChannel.class);
            b.childOption(EpollChannelOption.EPOLL_MODE, EpollMode.LEVEL_TRIGGERED);
        } else {
            b.channel(NioServerSocketChannel.class);
        }
        if (!this.keys.isEmpty()) {
            if (Epoll.isAvailable()) {
                b.option(EpollChannelOption.TCP_MD5SIG, this.keys);
            } else {
                throw new UnsupportedOperationException(Epoll.unavailabilityCause().getCause());
            }
        }
        b.childOption(ChannelOption.RCVBUF_ALLOCATOR, new FixedRecvByteBufAllocator(1));
        if (b.config().group() == null) {
            b.group(this.bossGroup, this.workerGroup);
        }
        return b;
    }

    @Override
    public final void close() {
        if (Epoll.isAvailable()) {
            this.workerGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
            this.bossGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
        }
    }

    public final PCEPSessionNegotiatorFactory<PCEPSessionImpl> getPCEPSessionNegotiatorFactory() {
        return this.snf;
    }

    protected static interface ChannelPipelineInitializer {
        public void initializeChannel(SocketChannel var1, Promise<PCEPSessionImpl> var2);
    }
}

