/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.Objects;
import org.opendaylight.protocol.pcep.spi.MessageRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class PCEPMessageToByteEncoder
extends MessageToByteEncoder<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(PCEPMessageToByteEncoder.class);
    private final MessageRegistry registry;

    public PCEPMessageToByteEncoder(MessageRegistry registry) {
        this.registry = Objects.requireNonNull(registry);
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Message msg, ByteBuf out) {
        Objects.requireNonNull(msg);
        this.registry.serializeMessage(msg, out);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Encoded : {}", (Object)ByteBufUtil.hexDump(out));
        }
    }
}

