/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.protocol.pcep.impl.PeerRecord;

@ThreadSafe
final class PCEPPeerRegistry {
    private static final long ID_CACHE_SECONDS = 10800L;
    private static final long PEER_CACHE_SECONDS = 86400L;
    private static final long PEER_CACHE_SIZE = 1024L;
    @GuardedBy(value="this")
    private final Cache<ByteArrayWrapper, PeerRecord> formerClients = CacheBuilder.newBuilder().expireAfterAccess(86400L, TimeUnit.SECONDS).maximumSize(1024L).build();
    @GuardedBy(value="this")
    private final Map<ByteArrayWrapper, SessionReference> sessions = new HashMap<ByteArrayWrapper, SessionReference>();

    PCEPPeerRegistry() {
    }

    protected synchronized Optional<SessionReference> getSessionReference(byte[] clientAddress) {
        SessionReference sessionReference = this.sessions.get(new ByteArrayWrapper(clientAddress));
        if (sessionReference != null) {
            return Optional.of(sessionReference);
        }
        return Optional.empty();
    }

    protected synchronized Optional<SessionReference> removeSessionReference(byte[] clientAddress) {
        SessionReference sessionReference = this.sessions.remove(new ByteArrayWrapper(clientAddress));
        if (sessionReference != null) {
            return Optional.of(sessionReference);
        }
        return Optional.empty();
    }

    protected synchronized void putSessionReference(byte[] clientAddress, SessionReference sessionReference) {
        this.sessions.put(new ByteArrayWrapper(clientAddress), sessionReference);
    }

    protected synchronized Short nextSession(byte[] clientAddress) throws ExecutionException {
        PeerRecord peer = this.formerClients.get(new ByteArrayWrapper(clientAddress), () -> new PeerRecord(10800L, null));
        return peer.allocId();
    }

    protected synchronized void releaseSession(byte[] clientAddress, short sessionId) throws ExecutionException {
        this.formerClients.get(new ByteArrayWrapper(clientAddress), () -> new PeerRecord(10800L, sessionId));
    }

    private static final class ByteArrayWrapper {
        private final byte[] byteArray;

        public ByteArrayWrapper(byte[] byteArray) {
            this.byteArray = byteArray == null ? null : (byte[])byteArray.clone();
        }

        public int hashCode() {
            return Arrays.hashCode(this.byteArray);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ByteArrayWrapper)) {
                return false;
            }
            return Arrays.equals(this.byteArray, ((ByteArrayWrapper)obj).byteArray);
        }
    }

    protected static interface SessionReference
    extends AutoCloseable {
        public Short getSessionId();
    }
}

