/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pce.id.object.PceId;

public abstract class AbstractPceIdObjectParser
extends CommonObjectParser
implements ObjectSerializer {
    private static final int CLASS = 25;

    public AbstractPceIdObjectParser(int objectType) {
        super(25, objectType);
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof PceId, "Wrong instance of PCEPObject. Passed %s. Needed PccIdReqObject.", object.getClass());
        PceId pceId = (PceId)object;
        if (pceId.getIpAddress().getIpv4AddressNoZone() != null) {
            ByteBuf body = Unpooled.buffer(4);
            ByteBufWriteUtil.writeIpv4Address(pceId.getIpAddress().getIpv4AddressNoZone(), body);
            ObjectUtil.formatSubobject(this.getObjectType(), this.getObjectClass(), object.isProcessingRule(), object.isIgnore(), body, buffer);
        } else if (pceId.getIpAddress().getIpv6AddressNoZone() != null) {
            ByteBuf body = Unpooled.buffer(16);
            ByteBufWriteUtil.writeIpv6Address(pceId.getIpAddress().getIpv6AddressNoZone(), body);
            ObjectUtil.formatSubobject(this.getObjectType(), this.getObjectClass(), object.isProcessingRule(), object.isIgnore(), body, buffer);
        }
    }
}

