/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.ErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.ErrorObjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.error.object.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.error.object.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.req.missing.tlv.ReqMissing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;

public final class PCEPErrorObjectParser
extends AbstractObjectWithTlvsParser<ErrorObjectBuilder> {
    private static final int CLASS = 13;
    private static final int TYPE = 1;
    private static final int FLAGS_F_LENGTH = 1;
    private static final int RESERVED = 1;

    public PCEPErrorObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg, 13, 1);
    }

    @Override
    public ErrorObject parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        ErrorObjectBuilder builder = new ErrorObjectBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        bytes.skipBytes(2);
        builder.setType(bytes.readUnsignedByte());
        builder.setValue(bytes.readUnsignedByte());
        this.parseTlvs(builder, bytes.slice());
        return builder.build();
    }

    @Override
    public void addTlv(ErrorObjectBuilder builder, Tlv tlv) {
        if (tlv instanceof ReqMissing && builder.getType().shortValue() == PCEPErrors.SYNC_PATH_COMP_REQ_MISSING.getErrorType()) {
            builder.setTlvs(new TlvsBuilder().setReqMissing((ReqMissing)tlv).build());
        }
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof ErrorObject, "Wrong instance of PCEPObject. Passed %s. Needed ErrorObject.", object.getClass());
        ErrorObject errObj = (ErrorObject)object;
        ByteBuf body = Unpooled.buffer();
        body.writeZero(2);
        Preconditions.checkArgument(errObj.getType() != null, "Type is mandatory.");
        ByteBufWriteUtil.writeUnsignedByte(errObj.getType(), body);
        Preconditions.checkArgument(errObj.getValue() != null, "Value is mandatory.");
        ByteBufWriteUtil.writeUnsignedByte(errObj.getValue(), body);
        this.serializeTlvs(errObj.getTlvs(), body);
        ObjectUtil.formatSubobject(1, 13, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs == null) {
            return;
        }
        if (tlvs.getReqMissing() != null) {
            this.serializeTlv(tlvs.getReqMissing(), body);
        }
        this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
    }

    @Override
    protected final void addVendorInformationTlvs(ErrorObjectBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setTlvs(new TlvsBuilder(builder.getTlvs()).setVendorInformationTlv(tlvs).build());
        }
    }
}

