/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.parser.object.AbstractXROWithSubobjectsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.XROSubobjectRegistry;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.XroBuilder;

public final class PCEPExcludeRouteObjectParser
extends AbstractXROWithSubobjectsParser {
    private static final int CLASS = 17;
    private static final int TYPE = 1;
    private static final int FLAGS_OFFSET = 3;

    public PCEPExcludeRouteObjectParser(XROSubobjectRegistry registry) {
        super(registry, 17, 1);
    }

    @Override
    public Xro parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        XroBuilder builder = new XroBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        bytes.skipBytes(3);
        builder.setFlags(new Xro.Flags(bytes.readBoolean()));
        builder.setSubobject(this.parseSubobjects(bytes.slice()));
        return builder.build();
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof Xro, "Wrong instance of PCEPObject. Passed %s. Needed XroObject.", object.getClass());
        Xro obj = (Xro)object;
        ByteBuf body = Unpooled.buffer();
        body.writeZero(3);
        ByteBufWriteUtil.writeBoolean(obj.getFlags() != null ? obj.getFlags().isFail() : null, body);
        this.serializeSubobject(obj.getSubobject(), body);
        ObjectUtil.formatSubobject(1, 17, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }
}

