/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import org.opendaylight.protocol.pcep.parser.object.AbstractEROWithSubobjectsParser;
import org.opendaylight.protocol.pcep.spi.EROSubobjectRegistry;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.IroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro.SubobjectBuilder;

public final class PCEPIncludeRouteObjectParser
extends AbstractEROWithSubobjectsParser {
    private static final int CLASS = 10;
    private static final int TYPE = 1;

    public PCEPIncludeRouteObjectParser(EROSubobjectRegistry subobjReg) {
        super(subobjReg, 10, 1);
    }

    @Override
    public Iro parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        IroBuilder builder = new IroBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        ArrayList<Subobject> subs = new ArrayList<Subobject>();
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject s2 : this.parseSubobjects(bytes)) {
            subs.add(new SubobjectBuilder().setLoose(s2.isLoose()).setSubobjectType(s2.getSubobjectType()).build());
        }
        builder.setSubobject(subs);
        return builder.build();
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof Iro, "Wrong instance of PCEPObject. Passed %s. Needed IroObject.", object.getClass());
        Iro iro = (Iro)object;
        ByteBuf body = Unpooled.buffer();
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject> subs = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject>();
        for (Subobject s2 : iro.getSubobject()) {
            subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.SubobjectBuilder().setLoose(s2.isLoose()).setSubobjectType(s2.getSubobjectType()).build());
        }
        this.serializeSubobject(subs, body);
        ObjectUtil.formatSubobject(1, 10, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }
}

