/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.parser.object.AbstractRROWithSubobjectsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.RROSubobjectRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.Rro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.RroBuilder;

public final class PCEPReportedRouteObjectParser
extends AbstractRROWithSubobjectsParser {
    public static final int CLASS = 8;
    public static final int TYPE = 1;

    public PCEPReportedRouteObjectParser(RROSubobjectRegistry subobjReg) {
        super(subobjReg, 8, 1);
    }

    @Override
    public Rro parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        RroBuilder builder = new RroBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        builder.setSubobject(this.parseSubobjects(bytes.slice()));
        return builder.build();
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof Rro, "Wrong instance of PCEPObject. Passed %s. Needed RroObject.", object.getClass());
        Rro obj = (Rro)object;
        ByteBuf body = Unpooled.buffer();
        this.serializeSubobject(obj.getSubobject(), body);
        ObjectUtil.formatSubobject(1, 8, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }
}

