/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.Order;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.setup.type.tlv.PathSetupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.RpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.rp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.rp.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;

public class PCEPRequestParameterObjectParser
extends AbstractObjectWithTlvsParser<TlvsBuilder> {
    private static final int CLASS = 2;
    private static final int TYPE = 1;
    private static final int FLAGS_SIZE = 32;
    private static final int FLAGS_SF_LENGTH = 29;
    private static final int FLAGS_SF_OFFSET = 0;
    private static final int PRI_SF_OFFSET = 29;
    private static final int O_FLAG_OFFSET = 26;
    private static final int B_FLAG_OFFSET = 27;
    private static final int R_FLAG_OFFSET = 28;
    private static final int M_FLAG_OFFSET = 21;
    private static final int D_FLAG_OFFSET = 22;
    private static final int P_FLAG_OFFSET = 23;
    private static final int S_FLAG_OFFSET = 24;
    private static final int F_FLAG_OFFSET = 18;
    private static final int N_FLAG_OFFSET = 19;
    private static final int E_FLAG_OFFSET = 20;

    public PCEPRequestParameterObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg, 2, 1);
    }

    @Override
    public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        BitArray flags = BitArray.valueOf(bytes, 32);
        RpBuilder builder = new RpBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        short priority = 0;
        priority = (short)(priority | (flags.get(31) ? 1 : 0));
        priority = (short)(priority | (flags.get(30) ? 1 : 0) << 1);
        priority = (short)(priority | (flags.get(29) ? 1 : 0) << 2);
        if (priority != 0) {
            builder.setPriority(priority);
        }
        builder.setFragmentation(flags.get(18));
        builder.setP2mp(flags.get(19));
        builder.setEroCompression(flags.get(20));
        builder.setMakeBeforeBreak(flags.get(21));
        builder.setOrder(flags.get(22));
        builder.setPathKey(flags.get(23));
        builder.setSupplyOf(flags.get(24));
        builder.setLoose(flags.get(26));
        builder.setBiDirectional(flags.get(27));
        builder.setReoptimization(flags.get(28));
        builder.setRequestId(new RequestId(bytes.readUnsignedInt()));
        TlvsBuilder tlvsBuilder = new TlvsBuilder();
        this.parseTlvs(tlvsBuilder, bytes.slice());
        builder.setTlvs(tlvsBuilder.build());
        return builder.build();
    }

    @Override
    public void addTlv(TlvsBuilder builder, Tlv tlv) {
        if (tlv instanceof Order) {
            builder.setOrder((Order)tlv);
        }
        if (tlv instanceof PathSetupType) {
            builder.setPathSetupType((PathSetupType)tlv);
        }
    }

    @Override
    public void serializeObject(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof Rp, "Wrong instance of PCEPObject. Passed %s. Needed RPObject.", object.getClass());
        ByteBuf body = Unpooled.buffer();
        Rp rpObj = (Rp)object;
        BitArray flags = new BitArray(32);
        flags.set(28, rpObj.isReoptimization());
        flags.set(27, rpObj.isBiDirectional());
        flags.set(26, rpObj.isLoose());
        flags.set(21, rpObj.isMakeBeforeBreak());
        flags.set(22, rpObj.isOrder());
        flags.set(23, rpObj.isPathKey());
        flags.set(24, rpObj.isSupplyOf());
        flags.set(18, rpObj.isFragmentation());
        flags.set(19, rpObj.isP2mp());
        flags.set(20, rpObj.isEroCompression());
        byte[] res = flags.array();
        if (rpObj.getPriority() != null) {
            byte p = UnsignedBytes.checkedCast(rpObj.getPriority().shortValue());
            res[res.length - 1] = (byte)(res[res.length - 1] | p);
        }
        body.writeBytes(res);
        Preconditions.checkArgument(rpObj.getRequestId() != null, "RequestId is mandatory");
        ByteBufWriteUtil.writeUnsignedInt(rpObj.getRequestId().getValue(), body);
        this.serializeTlvs(rpObj.getTlvs(), body);
        ObjectUtil.formatSubobject(1, 2, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs == null) {
            return;
        }
        if (tlvs.getOrder() != null) {
            this.serializeTlv(tlvs.getOrder(), body);
        }
        if (tlvs.getPathSetupType() != null) {
            this.serializeTlv(tlvs.getPathSetupType(), body);
        }
        this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
    }

    @Override
    protected final void addVendorInformationTlvs(TlvsBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setVendorInformationTlv(tlvs);
        }
    }
}

