/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.stream.Collectors;
import org.opendaylight.protocol.pcep.parser.object.AbstractRROWithSubobjectsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.RROSubobjectRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.secondary.reported.route.object.Srro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.secondary.reported.route.object.SrroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.secondary.reported.route.object.srro.SubobjectBuilder;

public final class PCEPSecondaryRecordRouteObjectParser
extends AbstractRROWithSubobjectsParser {
    private static final int CLASS = 30;
    private static final int TYPE = 1;
    private static String EMPTY_ARRAY_ERROR = "Array of bytes is mandatory. Can't be null or empty.";

    public PCEPSecondaryRecordRouteObjectParser(RROSubobjectRegistry subobjReg) {
        super(subobjReg, 30, 1);
    }

    @Override
    public Srro parseObject(ObjectHeader header, ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), EMPTY_ARRAY_ERROR);
        SrroBuilder builder = new SrroBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        List<Subobject> subObjects = this.parseSubobjects(buffer);
        builder.setSubobject(subObjects.stream().map(so -> new SubobjectBuilder().setSubobjectType(so.getSubobjectType()).setProtectionAvailable(so.isProtectionAvailable()).setProtectionInUse(so.isProtectionInUse()).build()).collect(Collectors.toList()));
        return builder.build();
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof Srro, "Wrong instance of PCEPObject. Passed %s. Needed EroObject.", object.getClass());
        Srro sero = (Srro)object;
        ByteBuf body = Unpooled.buffer();
        List<Subobject> subObjects = sero.getSubobject().stream().map(so -> new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.SubobjectBuilder().setSubobjectType(so.getSubobjectType()).setProtectionAvailable(so.isProtectionAvailable()).setProtectionInUse(so.isProtectionInUse()).build()).collect(Collectors.toList());
        this.serializeSubobject(subObjects, body);
        ObjectUtil.formatSubobject(1, 30, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }
}

