/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object.unreach;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.UnreachDestinationObj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.UnreachDestinationObjBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.destination.Ipv4DestinationCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.destination.Ipv4DestinationCaseBuilder;

public final class PCEPIpv4UnreachDestinationParser
extends CommonObjectParser {
    private static final int CLASS = 28;
    private static final int TYPE = 1;

    public PCEPIpv4UnreachDestinationParser() {
        super(28, 1);
    }

    public static void serializeObject(Boolean processing, Boolean ignore, Ipv4DestinationCase ipv4Case, ByteBuf buffer) {
        List<Ipv4AddressNoZone> dest = ipv4Case.getDestinationIpv4Address();
        Preconditions.checkArgument(dest != null, "DestinationIpv4Address is mandatory.");
        ByteBuf body = Unpooled.buffer(4 * dest.size());
        dest.forEach(ipv4 -> ByteBufWriteUtil.writeIpv4Address(ipv4, body));
        ObjectUtil.formatSubobject(1, 28, processing, ignore, body, buffer);
    }

    @Override
    public UnreachDestinationObj parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        UnreachDestinationObjBuilder builder = new UnreachDestinationObjBuilder();
        if (bytes.readableBytes() % 4 != 0) {
            throw new PCEPDeserializerException("Wrong length of array of bytes.");
        }
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        ArrayList<Ipv4AddressNoZone> dest = new ArrayList<Ipv4AddressNoZone>();
        while (bytes.isReadable()) {
            dest.add(Ipv4Util.noZoneAddressForByteBuf(bytes));
        }
        builder.setDestination(new Ipv4DestinationCaseBuilder().setDestinationIpv4Address(dest).build());
        return builder.build();
    }
}

